/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.ChangeOperation;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SelectionBasedTextOperationCommand;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.register.TextBlockRegisterContent;

public class BlockwiseChangeOperation
extends ChangeOperation {
    public static final BlockwiseChangeOperation INSTANCE = new BlockwiseChangeOperation();

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count, TextObject textObject) throws CommandExecutionException {
        Command beforeInsertCmd = BlockwiseChangeOperation.getHintCommand(editorAdaptor, count, textObject);
        Command afterInsertCmd = this.getLeaveHintCommand(editorAdaptor, count);
        editorAdaptor.changeMode("insert mode", new ExecuteCommandHint.OnEnter(beforeInsertCmd), new ExecuteCommandHint.OnLeave(afterInsertCmd));
    }

    Command getLeaveHintCommand(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Selection selection = editorAdaptor.getSelection();
        TextRange region = selection.getRegion(editorAdaptor, count);
        TextBlockRegisterContent yankContent = BlockWiseSelection.getTextBlockContent(editorAdaptor, region);
        return new SelectionBasedTextOperationCommand.BlockwiseRepeatCommand(this, count, true, true, yankContent);
    }
}

