/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.Arrays;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperation;

public class BlockwiseInsertShiftWidth
implements TextOperation {
    public static final TextOperation INSERT = new BlockwiseInsertShiftWidth(true);
    public static final TextOperation REMOVE = new BlockwiseInsertShiftWidth(false);
    private final boolean shiftRight;

    private BlockwiseInsertShiftWidth(boolean shiftRight) {
        this.shiftRight = shiftRight;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count, TextObject textObject) throws CommandExecutionException {
        int tabstop = editorAdaptor.getConfiguration().get(Options.TAB_STOP);
        tabstop = Math.max(1, tabstop);
        int shiftwidth = editorAdaptor.getConfiguration().get(Options.SHIFT_WIDTH);
        shiftwidth = Math.max(1, shiftwidth);
        boolean expandtab = editorAdaptor.getConfiguration().get(Options.EXPAND_TAB);
        if (count != 0) {
            shiftwidth = count * shiftwidth;
        }
        String replaceTab = new String(new char[tabstop]).replace('\u0000', ' ');
        String replaceShiftWidth = new String(new char[shiftwidth]).replace('\u0000', ' ');
        TextRange region = textObject.getRegion(editorAdaptor, 0);
        TextContent model = editorAdaptor.getModelContent();
        LineInformation line = model.getLineInformationOfOffset(region.getLeftBound().getModelOffset());
        if (line.getEndOffset() < region.getRightBound().getModelOffset()) {
            VrapperLog.error("Received incorrect shiftwidth segment! Start is at " + region.getLeftBound() + " with " + line + " but end is at " + region.getRightBound());
            throw new CommandExecutionException("Failed to shift block, bad line found.");
        }
        if (region.getModelLength() == 0 && line.getLength() == 0) {
            if (this.shiftRight) {
                StringBuilder indent = new StringBuilder(replaceShiftWidth);
                if (!expandtab) {
                    this.coalesceTabs("", indent, tabstop, 0, new int[1]);
                }
                model.replace(line.getBeginOffset(), 0, indent.toString());
            }
        } else {
            this.doIt(editorAdaptor, model, region, line, tabstop, shiftwidth, expandtab, replaceTab, replaceShiftWidth);
        }
    }

    private void doIt(EditorAdaptor editorAdaptor, TextContent model, TextRange region, LineInformation line, int tabstop, int shiftwidth, boolean expandtab, String replaceTab, String replaceShiftWidth) throws CommandExecutionException {
        int leftOff;
        String contents = model.getText(line.getBeginOffset(), line.getLength());
        int beginIndent = leftOff = region.getLeftBound().getModelOffset() - line.getBeginOffset();
        int endIndent = leftOff;
        while (endIndent < contents.length() && VimUtils.isWhiteSpace(contents.substring(endIndent, endIndent + 1))) {
            ++endIndent;
        }
        int[] visualOffsets = StringUtils.calculateVisualOffsets(contents, endIndent, tabstop);
        if (this.shiftRight) {
            while (beginIndent > 0 && VimUtils.isWhiteSpace(contents.substring(beginIndent - 1, beginIndent))) {
                --beginIndent;
            }
            int indentLength = endIndent - beginIndent;
            StringBuilder indent = this.expandTabs(contents, beginIndent, endIndent, leftOff, visualOffsets);
            indent.append(replaceShiftWidth);
            if (!expandtab) {
                this.coalesceTabs(contents, indent, tabstop, beginIndent, visualOffsets);
            }
            model.replace(line.getBeginOffset() + beginIndent, indentLength, indent.toString());
        } else if (VimUtils.isWhiteSpace(contents.substring(leftOff, leftOff + 1))) {
            StringBuilder replace = new StringBuilder();
            int indentLength = endIndent - beginIndent;
            int beginReplace = endIndent;
            while (beginReplace > leftOff && VimUtils.isWhiteSpace(contents.substring(beginReplace - 1, beginReplace)) && replace.length() < shiftwidth) {
                if (contents.charAt(--beginReplace) == '\t') {
                    int tabsize = visualOffsets[beginReplace + 1] - visualOffsets[beginReplace];
                    int i = 0;
                    while (i < tabsize) {
                        replace.append(' ');
                        ++i;
                    }
                    continue;
                }
                if (contents.charAt(beginReplace) == ' ') {
                    replace.append(' ');
                    continue;
                }
                throw new CommandExecutionException("Found weird indentation at " + line + ", contents: [" + contents + "].");
            }
            if (replace.length() > shiftwidth) {
                replace.setLength(replace.length() - shiftwidth);
            } else {
                replace.setLength(0);
            }
            int replacedChars = endIndent - beginReplace;
            model.replace(line.getBeginOffset() + beginReplace, replacedChars, replace.toString());
        }
    }

    public StringBuilder expandTabs(String contents, int beginIndent, int endIndent, int leftOff, int[] visualOffsets) {
        int nspaces = 0;
        int i = beginIndent;
        while (i < endIndent) {
            int visualWidth = visualOffsets[i + 1] - visualOffsets[i];
            if (i < leftOff && visualWidth > 1) {
                leftOff += visualWidth - 1;
            }
            nspaces += visualWidth;
            ++i;
        }
        char[] spaces = new char[nspaces];
        Arrays.fill(spaces, ' ');
        return new StringBuilder().append(spaces);
    }

    private void coalesceTabs(String contents, StringBuilder indent, int tabstop, int beginIndent, int[] visualOffsets) {
        int beginIndentVOff = visualOffsets[beginIndent];
        int nextTabstopOff = (beginIndentVOff + (tabstop - 1)) / tabstop * tabstop;
        int tabstopDiff = nextTabstopOff - beginIndentVOff;
        int index = 0;
        if (tabstopDiff > 0 && indent.length() >= tabstopDiff) {
            indent.replace(0, tabstopDiff, "\t");
            index = 1;
        }
        while (indent.length() - index >= tabstop) {
            indent.replace(index, index + tabstop, "\t");
            ++index;
        }
    }

    @Override
    public TextOperation repetition() {
        return this;
    }
}

