/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.YankOperation;

public class BlockwiseYankCommand
extends AbstractCommand {
    public static final BlockwiseYankCommand INSTANCE = new BlockwiseYankCommand();

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        editorAdaptor.rememberLastActiveSelection();
        Selection selection = editorAdaptor.getSelection();
        TextRange blockRange = selection.getRegion(editorAdaptor, 0);
        YankOperation.doIt(editorAdaptor, blockRange, ContentType.TEXT_RECTANGLE, true);
        LeaveVisualModeCommand.doIt(editorAdaptor);
    }

    @Override
    public Command repetition() {
        return this;
    }

    @Override
    public Command withCount(int count) {
        return this;
    }
}

