/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.VisualMotionCommand;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;
import net.sourceforge.vrapper.vim.modes.TemporaryMode;

public class ChangeToVisualModeCommand
extends CountIgnoringNonRepeatableCommand {
    protected final String mode;
    protected final Command command;

    public ChangeToVisualModeCommand(String mode) {
        this(mode, (Command)null);
    }

    public ChangeToVisualModeCommand(String mode, Motion motion) {
        this(mode, new VisualMotionCommand(motion));
    }

    public ChangeToVisualModeCommand(String mode, Command command) {
        this.mode = mode;
        this.command = command;
        if (mode == null) {
            throw new IllegalArgumentException("Mode must not be null!");
        }
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        String targetMode = this.mode;
        if (editorAdaptor.getCurrentMode() instanceof TemporaryMode) {
            if (this.mode.equalsIgnoreCase("visual mode")) {
                targetMode = "temporary visual mode";
            } else if (this.mode.equalsIgnoreCase("linewise visual mode")) {
                targetMode = "temporary linewise visual mode";
            }
        }
        editorAdaptor.changeMode(targetMode, AbstractVisualMode.FIX_SELECTION_HINT);
        ((AbstractVisualMode)editorAdaptor.getCurrentMode()).placeCursor(StickyColumnPolicy.NEVER);
        if (this.command != null) {
            this.command.execute(editorAdaptor);
        }
    }
}

