/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;

public class CloseCommand
extends CountIgnoringNonRepeatableCommand {
    public static final Command FORCED_CLOSE = new CloseCommand(true, CloseOption.ONE);
    public static final Command CLOSE = new CloseCommand(false, CloseOption.ONE);
    public static final Command FORCED_CLOSE_ALL = new CloseCommand(true, CloseOption.ALL);
    public static final Command CLOSE_ALL = new CloseCommand(false, CloseOption.ALL);
    public static final Command FORCED_CLOSE_OTHERS = new CloseCommand(true, CloseOption.OTHERS);
    public static final Command CLOSE_OTHERS = new CloseCommand(false, CloseOption.OTHERS);
    private final boolean force;
    private final CloseOption option;

    private CloseCommand(boolean force, CloseOption option) {
        this.force = force;
        this.option = option;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        boolean success = false;
        switch (this.option) {
            case ONE: {
                success = editorAdaptor.getFileService().close(this.force);
                break;
            }
            case ALL: {
                success = editorAdaptor.getFileService().closeAll(this.force);
                break;
            }
            case OTHERS: {
                success = editorAdaptor.getFileService().closeOthers(this.force);
            }
        }
        if (!success) {
            throw new CommandExecutionException("There are unsaved changes");
        }
    }

    private static enum CloseOption {
        ONE,
        ALL,
        OTHERS;

    }
}

