/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LineWiseOperation;
import net.sourceforge.vrapper.vim.commands.SimpleTextOperation;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.YankOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.RegisterManager;

public class DeleteOperation
extends SimpleTextOperation
implements LineWiseOperation {
    public static final DeleteOperation INSTANCE = new DeleteOperation();

    private DeleteOperation() {
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.singleLine(editorAdaptor, currentPos);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        this.execute(editorAdaptor, lineRange.getRegion(editorAdaptor, 0), ContentType.LINES);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, TextRange region, ContentType contentType) {
        if (region == null || region.getModelLength() == 0 && contentType != ContentType.LINES) {
            return;
        }
        try {
            editorAdaptor.getHistory().beginCompoundChange();
            TextContent txtContent = editorAdaptor.getModelContent();
            int position = region.getLeftBound().getModelOffset();
            int length = region.getModelLength();
            String text = txtContent.getText(position, length);
            if (!(contentType != ContentType.LINES || position <= 0 || text.length() != 0 && VimUtils.isNewLine(text.substring(text.length() - 1)))) {
                LineInformation line = txtContent.getLineInformationOfOffset(position);
                int previousNewlinePos = txtContent.getLineInformation(line.getNumber() - 1).getEndOffset();
                Position newPosition = region.getLeftBound().addModelOffset(-(position - previousNewlinePos));
                region = new StartEndTextRange(newPosition, region.getRightBound());
            }
            DeleteOperation.doIt(editorAdaptor, region, contentType);
        }
        finally {
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    @Override
    public TextOperation repetition() {
        return this;
    }

    public static void doIt(EditorAdaptor editorAdaptor, TextRange range, ContentType contentType) {
        if (range == null) {
            return;
        }
        YankOperation.doIt(editorAdaptor, range, contentType, false);
        RegisterManager registerManager = editorAdaptor.getRegisterManager();
        if (registerManager.isDefaultRegisterActive()) {
            RegisterContent register = registerManager.getActiveRegister().getContent();
            registerManager.setLastDelete(register);
        }
        TextContent txtContent = editorAdaptor.getModelContent();
        CursorService cur = editorAdaptor.getCursorService();
        int position = range.getLeftBound().getModelOffset();
        int length = range.getModelLength();
        txtContent.replace(position, length, "");
        if (contentType == ContentType.LINES) {
            LineInformation lastLine = txtContent.getLineInformationOfOffset(position);
            int indent = VimUtils.getIndent(txtContent, lastLine).length();
            int offset = lastLine.getBeginOffset() + indent;
            cur.setPosition(cur.newPositionForModelOffset(offset), StickyColumnPolicy.ON_CHANGE);
        } else {
            cur.setPosition(cur.getPosition(), StickyColumnPolicy.ON_CHANGE);
        }
    }
}

