/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.DelimitedText;

public abstract class DelimitedTextObject
extends AbstractTextObject {
    protected final DelimitedText delimitedText;

    public DelimitedTextObject(DelimitedText delimitedText) {
        this.delimitedText = delimitedText;
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Position currentPosition = editorAdaptor.getPosition();
        int currentOffset = currentPosition.getModelOffset();
        TextRange leftDelimiter = this.delimitedText.leftDelimiter(currentOffset, editorAdaptor, count);
        TextRange rightDelimiter = this.delimitedText.rightDelimiter(currentOffset, editorAdaptor, count);
        return this.getRegion(leftDelimiter, rightDelimiter);
    }

    protected abstract TextRange getRegion(TextRange var1, TextRange var2);

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.TEXT;
    }
}

