/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.SubstitutionDefinition;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.AnonymousMacroOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.LineWiseOperation;
import net.sourceforge.vrapper.vim.commands.SubstitutionOperation;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.YankOperation;

public class ExCommandOperation
extends AbstractLinewiseOperation {
    protected static final String NEXTLINE_MARK = "x-vrapper--ex-nextline";
    String originalDefinition;

    public ExCommandOperation(String definition) {
        this.originalDefinition = definition;
    }

    @Override
    public TextOperation repetition() {
        if (this.originalDefinition.contains("normal ")) {
            return null;
        }
        return this;
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.entireFile(editorAdaptor);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        boolean findMatch = true;
        String definition = this.originalDefinition;
        if (definition.startsWith("g!")) {
            findMatch = false;
            definition = definition.substring(2);
        } else if (definition.startsWith("v")) {
            findMatch = false;
            definition = definition.substring(1);
        } else if (definition.startsWith("g")) {
            findMatch = true;
            definition = definition.substring(1);
        } else {
            VrapperLog.error("Expected a g or v instruction but got [" + this.originalDefinition + "]");
            throw new CommandExecutionException("Parsing error");
        }
        char delimiter = definition.charAt(0);
        int patternEnd = definition.indexOf(delimiter, 1);
        if (patternEnd == -1) {
            throw new CommandExecutionException("Missing separator!");
        }
        String pattern = definition.substring(1, patternEnd);
        if (pattern.length() == 0 && (pattern = editorAdaptor.getRegisterManager().getRegister("/").getContent().getText()).length() == 0) {
            throw new CommandExecutionException("No search pattern given and no active search!");
        }
        if (definition.length() <= patternEnd + 1) {
            throw new CommandExecutionException("No ex command to execute on pattern match!");
        }
        LineWiseOperation operation = this.buildExCommand(definition = definition.substring(patternEnd + 1), editorAdaptor);
        if (operation != null) {
            this.executeExCommand(lineRange, findMatch, pattern, operation, editorAdaptor);
        }
    }

    private LineWiseOperation buildExCommand(String command, EditorAdaptor editorAdaptor) throws CommandExecutionException {
        if (command.startsWith("normal ")) {
            String args = command.substring("normal ".length());
            return new AnonymousMacroOperation(args);
        }
        if (command.startsWith("s")) {
            SubstitutionDefinition definition;
            try {
                definition = new SubstitutionDefinition(command, editorAdaptor.getRegisterManager());
            }
            catch (IllegalArgumentException e) {
                throw new CommandExecutionException(e.getMessage());
            }
            if (definition.hasFlag('c')) {
                throw new CommandExecutionException("Cannot use 'c' substitute flag in a global subcommand!");
            }
            return new SubstitutionOperation(definition);
        }
        if (command.startsWith("d")) {
            return DeleteOperation.INSTANCE;
        }
        if (command.startsWith("y")) {
            if (command.length() >= 3) {
                return new YankOperation(command.substring(command.length() - 1));
            }
            return YankOperation.INSTANCE;
        }
        return null;
    }

    private void executeExCommand(LineRange lineRange, boolean findMatch, String pattern, LineWiseOperation operation, EditorAdaptor editorAdaptor) {
        int startLine = lineRange.getStartLine();
        int endLine = lineRange.getEndLine();
        TextContent modelContent = editorAdaptor.getModelContent();
        LineInformation line = modelContent.getLineInformation(startLine);
        editorAdaptor.getHistory().beginCompoundChange();
        editorAdaptor.getHistory().lock("ex-command");
        try {
            if (startLine == endLine) {
                this.processLine(pattern, findMatch, operation, line, editorAdaptor);
            } else {
                this.processMultipleLines(findMatch, pattern, operation, editorAdaptor, line, startLine, endLine, modelContent);
            }
        }
        finally {
            editorAdaptor.getHistory().unlock("ex-command");
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    private void processMultipleLines(boolean findMatch, String pattern, LineWiseOperation operation, EditorAdaptor editorAdaptor, LineInformation line, int startLine, int endLine, TextContent modelContent) {
        int linesProcessed = 0;
        int nLines = modelContent.getNumberOfLines();
        int maxLinesToProcess = endLine - startLine + 1;
        CursorService cs = editorAdaptor.getCursorService();
        while (linesProcessed < maxLinesToProcess && line != null) {
            nLines = modelContent.getNumberOfLines();
            if (nLines > ((LineInformation)line).getNumber() + 1) {
                LineInformation nextLine = modelContent.getLineInformation(((LineInformation)line).getNumber() + 1);
                cs.setMark(NEXTLINE_MARK, cs.newPositionForModelOffset(nextLine.getBeginOffset()));
            } else {
                cs.deleteMark(NEXTLINE_MARK);
            }
            this.processLine(pattern, findMatch, operation, (LineInformation)line, editorAdaptor);
            Position nextLineStart = cs.getMark(NEXTLINE_MARK);
            int updatedNLines = modelContent.getNumberOfLines();
            if (nextLineStart == null && nLines > updatedNLines) {
                if (((LineInformation)line).getNumber() >= updatedNLines) {
                    line = null;
                }
            } else {
                line = nextLineStart == null ? (((LineInformation)line).getNumber() + 1 >= updatedNLines ? null : modelContent.getLineInformation(((LineInformation)line).getNumber() + 1)) : modelContent.getLineInformationOfOffset(nextLineStart.getModelOffset());
            }
            ++linesProcessed;
        }
        cs.deleteMark(NEXTLINE_MARK);
    }

    private boolean processLine(String pattern, boolean findMatch, LineWiseOperation operation, LineInformation line, EditorAdaptor editorAdaptor) {
        boolean operationPerformed = false;
        String text = editorAdaptor.getModelContent().getText(line.getBeginOffset(), line.getLength());
        if (!pattern.startsWith("^")) {
            pattern = ".*" + pattern;
        }
        if (!pattern.endsWith("$")) {
            pattern = String.valueOf(pattern) + ".*";
        }
        boolean matches = text.matches(pattern);
        if (findMatch && matches || !findMatch && !matches) {
            try {
                SimpleLineRange singleLine = SimpleLineRange.singleLineInModel(editorAdaptor, line);
                operation.execute(editorAdaptor, singleLine);
                operationPerformed = true;
            }
            catch (CommandExecutionException commandExecutionException) {}
        }
        return operationPerformed;
    }
}

