/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.commandline.SearchCommandParser;

public class ExSearchCommand
extends CountAwareCommand {
    private final String first;
    private final String command;

    public ExSearchCommand(String first, String command) {
        this.first = first;
        this.command = command;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Position cursor = editorAdaptor.getPosition();
        SearchCommandParser parser = new SearchCommandParser(editorAdaptor, new MotionCommand(SearchResultMotion.REPEAT));
        parser.parseAndExecute(this.first, this.command).execute(editorAdaptor);
        if (cursor.getModelOffset() != editorAdaptor.getPosition().getModelOffset()) {
            TextContent model = editorAdaptor.getModelContent();
            cursor = editorAdaptor.getPosition();
            LineInformation line = model.getLineInformationOfOffset(cursor.getModelOffset());
            int newPos = VimUtils.getFirstNonWhiteSpaceOffset(model, line);
            editorAdaptor.setPosition(cursor.setModelOffset(newPos), StickyColumnPolicy.ON_CHANGE);
        }
    }

    @Override
    public CountAwareCommand repetition() {
        return null;
    }
}

