/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class IncrementDecrementCommand
extends CountAwareCommand {
    public static final IncrementDecrementCommand INCREMENT = new IncrementDecrementCommand(true);
    public static final IncrementDecrementCommand DECREMENT = new IncrementDecrementCommand(false);
    private boolean increment;

    private IncrementDecrementCommand(boolean increment) {
        this.increment = increment;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 1;
        }
        Position cursor = editorAdaptor.getCursorService().getPosition();
        TextContent content = editorAdaptor.getModelContent();
        LineInformation line = content.getLineInformationOfOffset(cursor.getModelOffset());
        int cursorIndex = cursor.getModelOffset() - line.getBeginOffset();
        String text = content.getText(line.getBeginOffset(), line.getLength());
        NumBoundary boundary = null;
        NumBoundary hexBoundary = this.findHex(text, cursorIndex);
        NumBoundary numBoundary = this.findIntegers(text, cursorIndex);
        boundary = numBoundary == null || hexBoundary != null && (numBoundary.numStartIndex >= hexBoundary.numStartIndex || numBoundary.numStartIndex == hexBoundary.numStartIndex - 2) ? hexBoundary : numBoundary;
        if (boundary == null) {
            return;
        }
        String origNumStr = text.substring(boundary.numStartIndex, boundary.numEndIndex + 1);
        String numStr = this.modifyNumber(origNumStr, count, boundary.radix);
        if (numStr == null) {
            return;
        }
        if (boundary.radix == 8) {
            while (origNumStr.length() > numStr.length() + 1) {
                numStr = String.valueOf('0') + numStr;
            }
            numStr = String.valueOf('0') + numStr;
        } else if (boundary.radix == 16) {
            while (origNumStr.length() > numStr.length()) {
                numStr = String.valueOf('0') + numStr;
            }
            if (origNumStr.matches(".*[A-F].*")) {
                numStr = numStr.toUpperCase();
            }
        }
        content.replace(line.getBeginOffset() + boundary.numStartIndex, boundary.numEndIndex + 1 - boundary.numStartIndex, numStr);
        Position newPos = editorAdaptor.getCursorService().newPositionForModelOffset(line.getBeginOffset() + boundary.numStartIndex + numStr.length() - 1);
        editorAdaptor.getCursorService().setPosition(newPos, StickyColumnPolicy.ON_CHANGE);
    }

    private NumBoundary findHex(String text, int index) {
        if (!text.matches(".*0[xX].*")) {
            return null;
        }
        int hexEndIndex = this.findHexEndBoundary(text, index);
        if (hexEndIndex == -1) {
            return null;
        }
        int hexStartIndex = this.findHexStartBoundary(text, hexEndIndex);
        if (hexStartIndex >= 2 && (text.charAt(hexStartIndex - 1) == 'x' || text.charAt(hexStartIndex - 1) == 'X') && text.charAt(hexStartIndex - 2) == '0') {
            return new NumBoundary(hexStartIndex, hexEndIndex, 16);
        }
        if (text.indexOf("0x", index) > -1 || text.indexOf("0X", index) > -1) {
            int newStart = text.indexOf("0x", index);
            int otherChoice = text.indexOf("0X", index);
            if (otherChoice != -1 && otherChoice < newStart) {
                newStart = otherChoice;
            }
            return this.findHex(text, newStart);
        }
        return null;
    }

    private NumBoundary findIntegers(String text, int index) {
        int numEndIndex = this.findNumEndBoundary(text, index);
        if (numEndIndex == -1) {
            return null;
        }
        int numStartIndex = this.findNumStartBoundary(text, numEndIndex);
        String numStr = text.substring(numStartIndex, numEndIndex + 1);
        if (text.charAt(numStartIndex) == '0' && this.isOctal(numStr)) {
            return new NumBoundary(numStartIndex, numEndIndex, 8);
        }
        return new NumBoundary(numStartIndex, numEndIndex, 10);
    }

    private boolean isOctal(String numStr) {
        if (numStr.length() == 1 && numStr.charAt(0) == '0') {
            return false;
        }
        int i = 0;
        while (i < numStr.length()) {
            if (Character.digit(numStr.charAt(i), 8) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String modifyNumber(String numStr, int count, int radix) {
        long numVal;
        try {
            numVal = Long.parseLong(numStr, radix);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        numVal = this.increment ? (numVal += (long)count) : (numVal -= (long)count);
        return Long.toString(numVal, radix);
    }

    private int findNumEndBoundary(String text, int startIndex) {
        boolean foundNumber = false;
        int offset = -1;
        int i = startIndex;
        while (i < text.length()) {
            if (foundNumber || Character.isDigit(text.charAt(i))) {
                if (foundNumber && !Character.isDigit(text.charAt(i))) break;
                foundNumber = true;
                offset = i;
            }
            ++i;
        }
        return offset;
    }

    private int findHexEndBoundary(String text, int startIndex) {
        boolean foundHex = false;
        int offset = -1;
        int i = startIndex;
        while (i < text.length()) {
            char test = text.charAt(i);
            if (foundHex || Character.digit(test, 16) != -1) {
                if (foundHex && Character.digit(test, 16) == -1) break;
                if (foundHex || test != '0' || text.length() <= i + 1 || text.charAt(i + 1) == 'x') {
                    // empty if block
                }
                foundHex = true;
                offset = ++i;
            }
            ++i;
        }
        return offset;
    }

    private int findNumStartBoundary(String text, int startIndex) {
        int offset = 0;
        int i = startIndex;
        while (i >= 0) {
            if (Character.isDigit(text.charAt(i))) {
                offset = i--;
                continue;
            }
            if (text.charAt(i) != '-') break;
            offset = i;
            break;
        }
        return offset;
    }

    private int findHexStartBoundary(String text, int startIndex) {
        int offset = 0;
        int i = startIndex;
        while (i >= 0) {
            if (Character.digit(text.charAt(i), 16) <= -1) break;
            offset = i--;
        }
        return offset;
    }

    @Override
    public CountAwareCommand repetition() {
        return this;
    }

    private class NumBoundary {
        int numStartIndex;
        int numEndIndex;
        int radix;

        public NumBoundary(int numStartIndex, int numEndIndex, int radix) {
            this.numStartIndex = numStartIndex;
            this.numEndIndex = numEndIndex;
            this.radix = radix;
        }
    }
}

