/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public final class InsertLineCommand
implements Command {
    public static final InsertLineCommand PRE_CURSOR = new InsertLineCommand(Type.PRE_CURSOR);
    public static final InsertLineCommand POST_CURSOR = new InsertLineCommand(Type.POST_CURSOR);
    private final Type type;

    private InsertLineCommand(Type type) {
        this.type = type;
    }

    @Override
    public final void execute(EditorAdaptor vim) {
        TextContent p = vim.getModelContent();
        LineInformation line = p.getLineInformationOfOffset(vim.getCursorService().getPosition().getModelOffset());
        InsertLineCommand.doIt(vim, this.type, line);
    }

    public static final void doIt(EditorAdaptor vim, Type type, LineInformation line) {
        if (vim.getConfiguration().get(Options.SMART_INDENT).booleanValue()) {
            type.smart(vim, line);
        } else {
            boolean autoindent = vim.getConfiguration().get(Options.AUTO_INDENT);
            String indent = autoindent ? VimUtils.getIndent(vim.getModelContent(), line) : "";
            type.dumb(vim, line, indent);
        }
    }

    @Override
    public Command repetition() {
        return this;
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public Command withCount(int count) {
        return this;
    }

    public static enum Type {
        PRE_CURSOR{

            @Override
            void dumb(EditorAdaptor vim, LineInformation line, String indent) {
                TextContent p = vim.getModelContent();
                String newline = vim.getConfiguration().getNewLine();
                p.replace(line.getBeginOffset(), 0, String.valueOf(indent) + newline);
                vim.getCursorService().setPosition(vim.getCursorService().newPositionForModelOffset(line.getBeginOffset() + indent.length()), StickyColumnPolicy.ON_CHANGE);
            }

            @Override
            void smart(EditorAdaptor vim, LineInformation line) {
                TextContent p = vim.getModelContent();
                String newline = vim.getConfiguration().getNewLine();
                CursorService cs = vim.getCursorService();
                if (line.getNumber() != 0) {
                    int index = p.getLineInformation(line.getNumber() - 1).getEndOffset();
                    p.smartInsert(index, newline);
                    cs.setPosition(cs.newPositionForModelOffset(p.getLineInformation(line.getNumber()).getEndOffset()), StickyColumnPolicy.ON_CHANGE);
                } else {
                    p.smartInsert(0, newline);
                    cs.setPosition(cs.newPositionForModelOffset(0), StickyColumnPolicy.ON_CHANGE);
                }
            }
        }
        ,
        POST_CURSOR{

            @Override
            void dumb(EditorAdaptor vim, LineInformation line, String indent) {
                TextContent p = vim.getModelContent();
                int begin = line.getEndOffset();
                if (line.getNumber() == p.getNumberOfLines() - 1) {
                    ++begin;
                }
                String newline = vim.getConfiguration().getNewLine();
                p.replace(begin, 0, String.valueOf(newline) + indent);
                CursorService cursorService = vim.getCursorService();
                cursorService.setPosition(cursorService.newPositionForModelOffset(begin + indent.length() + newline.length()), StickyColumnPolicy.ON_CHANGE);
            }

            @Override
            void smart(EditorAdaptor vim, LineInformation line) {
                String newline = vim.getConfiguration().getNewLine();
                TextContent p = vim.getModelContent();
                CursorService cs = vim.getCursorService();
                int begin = line.getEndOffset();
                p.smartInsert(begin, newline);
                cs.setPosition(cs.newPositionForModelOffset(p.getLineInformation(line.getNumber() + 1).getEndOffset()), StickyColumnPolicy.ON_CHANGE);
            }
        };


        abstract void smart(EditorAdaptor var1, LineInformation var2);

        abstract void dumb(EditorAdaptor var1, LineInformation var2, String var3);
    }
}

