/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class InsertShiftWidth
implements TextOperation {
    public static final InsertShiftWidth INSERT = new InsertShiftWidth(true, false);
    public static final InsertShiftWidth REMOVE = new InsertShiftWidth(false, false);
    public static final InsertShiftWidth INSERT_VISUAL = new InsertShiftWidth(true, true);
    public static final InsertShiftWidth REMOVE_VISUAL = new InsertShiftWidth(false, true);
    private final boolean shiftRight;
    private final boolean visualMode;

    private InsertShiftWidth(boolean shiftRight, boolean visualMode) {
        this.shiftRight = shiftRight;
        this.visualMode = visualMode;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count, TextObject textObject) throws CommandExecutionException {
        TextRange region;
        int tabstop = editorAdaptor.getConfiguration().get(Options.TAB_STOP);
        tabstop = Math.max(1, tabstop);
        int shiftwidth = editorAdaptor.getConfiguration().get(Options.SHIFT_WIDTH);
        shiftwidth = Math.max(1, shiftwidth);
        boolean expandtab = editorAdaptor.getConfiguration().get(Options.EXPAND_TAB);
        if (this.visualMode) {
            region = textObject.getRegion(editorAdaptor, 0);
            if (count != 0) {
                shiftwidth *= count;
            }
        } else {
            region = textObject.getRegion(editorAdaptor, Math.abs(count));
        }
        String replaceTab = new String(new char[tabstop]).replace('\u0000', ' ');
        String replaceShiftWidth = new String(new char[shiftwidth]).replace('\u0000', ' ');
        TextContent model = editorAdaptor.getModelContent();
        if (region == null) {
            LineInformation line = model.getLineInformationOfOffset(editorAdaptor.getPosition().getModelOffset());
            this.doIt(line, model, expandtab, true, tabstop, shiftwidth, replaceTab, replaceShiftWidth);
        } else {
            int startLine = this.calculateStartLine(model, region.getLeftBound().getModelOffset(), region.getRightBound().getModelOffset());
            if (startLine < 0) {
                return;
            }
            int endLine = this.calculateEndLine(model, region.getRightBound().getModelOffset());
            boolean shiftround = editorAdaptor.getConfiguration().get(Options.SHIFT_ROUND);
            editorAdaptor.getHistory().beginCompoundChange();
            int i = startLine;
            while (i < endLine) {
                LineInformation line = model.getLineInformation(i);
                ++i;
                if (line.getLength() == 0) continue;
                this.doIt(line, model, expandtab, shiftround, tabstop, shiftwidth, replaceTab, replaceShiftWidth);
            }
            editorAdaptor.getHistory().endCompoundChange();
            editorAdaptor.setPosition(editorAdaptor.getCursorService().newPositionForModelOffset(VimUtils.getFirstNonWhiteSpaceOffset(model, model.getLineInformation(startLine))), StickyColumnPolicy.ON_CHANGE);
        }
    }

    private int calculateStartLine(TextContent model, int startOffset, int endOffset) {
        int startLine;
        if (VimUtils.isNewLine(model.getText(startOffset, 1))) {
            startLine = model.getLineInformationOfOffset(startOffset).getNumber() + 1;
            if (endOffset - startOffset == 1) {
                return -1;
            }
        } else {
            startLine = model.getLineInformationOfOffset(startOffset).getNumber();
        }
        return startLine;
    }

    private int calculateEndLine(TextContent model, int endOffset) {
        LineInformation endLineInformation = model.getLineInformationOfOffset(endOffset);
        String endText = model.getText(endLineInformation.getBeginOffset(), endLineInformation.getLength());
        int endLine = endLineInformation.getNumber();
        if (endOffset > endLineInformation.getBeginOffset() && !endText.matches("\\s*")) {
            ++endLine;
        }
        return endLine;
    }

    /*
     * Unable to fully structure code
     */
    private void doIt(LineInformation line, TextContent model, boolean expandtab, boolean shiftround, int tabstop, int shiftwidth, String replaceTab, String replaceShiftWidth) {
        block5: {
            block6: {
                block4: {
                    lineStr = model.getText(line.getBeginOffset(), line.getLength());
                    whitespaceEnd = VimUtils.getFirstNonWhiteSpaceOffset(model, line) - line.getBeginOffset();
                    indent = lineStr.substring(0, whitespaceEnd);
                    indent = indent.replaceAll("\t", replaceTab);
                    if (!this.shiftRight) break block4;
                    if (shiftround && indent.length() % shiftwidth != 0) ** GOTO lbl10
                    indent = String.valueOf(replaceShiftWidth) + indent;
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        indent = String.valueOf(indent) + " ";
lbl10:
                        // 2 sources

                        ** while (indent.length() % shiftwidth != 0)
                    }
lbl11:
                    // 1 sources

                    break block5;
                }
                if (shiftwidth <= indent.length()) break block6;
                indent = "";
                break block5;
            }
            if (indent.length() < shiftwidth || shiftround && indent.length() % shiftwidth != 0) ** GOTO lbl21
            indent = indent.substring(shiftwidth);
            break block5;
lbl-1000:
            // 1 sources

            {
                indent = indent.substring(1);
lbl21:
                // 2 sources

                ** while (indent.length() % shiftwidth != 0)
            }
        }
        replace = "";
        if (!expandtab) {
            while (indent.length() >= tabstop) {
                indent = indent.substring(tabstop);
                replace = String.valueOf(replace) + "\t";
            }
        }
        replace = String.valueOf(replace) + indent;
        model.replace(line.getBeginOffset(), whitespaceEnd, replace);
    }

    @Override
    public TextOperation repetition() {
        return this;
    }
}

