/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.EditorMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.TemporaryMode;

public class LeaveVisualModeCommand
extends CountIgnoringNonRepeatableCommand {
    public static final Command INSTANCE = new LeaveVisualModeCommand();

    private LeaveVisualModeCommand() {
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        editorAdaptor.rememberLastActiveSelection();
        Selection selection = editorAdaptor.getSelection();
        Position exitPoint = selection.getTo();
        editorAdaptor.setPosition(exitPoint, StickyColumnPolicy.ON_CHANGE);
        LeaveVisualModeCommand.doIt(editorAdaptor);
    }

    public static void doIt(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        editorAdaptor.setSelection(null);
        EditorMode currentMode = editorAdaptor.getMode(editorAdaptor.getCurrentModeName());
        if (currentMode instanceof TemporaryMode) {
            editorAdaptor.changeMode("insert mode", new ModeSwitchHint[0]);
        } else {
            editorAdaptor.changeMode("normal mode", new ModeSwitchHint[0]);
        }
    }
}

