/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.utils.LineAddressParser;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.SubstitutionDefinition;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AnonymousMacroOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CopyMoveLinesOperation;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.ExCommandOperation;
import net.sourceforge.vrapper.vim.commands.LineWiseOperation;
import net.sourceforge.vrapper.vim.commands.PipeExternalOperation;
import net.sourceforge.vrapper.vim.commands.ReadExternalOperation;
import net.sourceforge.vrapper.vim.commands.RetabOperation;
import net.sourceforge.vrapper.vim.commands.SortOperation;
import net.sourceforge.vrapper.vim.commands.SubstitutionOperation;
import net.sourceforge.vrapper.vim.commands.YankOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.ConfirmSubstitutionMode;

public class LineRangeOperationCommand
extends CountIgnoringNonRepeatableCommand {
    private static final String START_SEL_RE = "^\\s*(%|\\$|[+-.]?\\d+|\\.|\\^|'[<\\[a-zA-Z]|([?\\/])((?:\\\\2|.)+?)\\2)([+-]\\d+)?\\s*";
    private static final String END_SEL_RE = "\\s*[,;]\\s*([+-.]?\\d+|\\.|\\$|'[>\\]a-zA-Z]|([?\\/])((?:\\\\6|.)+?)\\6)([+-]\\d+)?\\s*";
    private static final Pattern START_AND_STOP = Pattern.compile("^\\s*(%|\\$|[+-.]?\\d+|\\.|\\^|'[<\\[a-zA-Z]|([?\\/])((?:\\\\2|.)+?)\\2)([+-]\\d+)?\\s*\\s*[,;]\\s*([+-.]?\\d+|\\.|\\$|'[>\\]a-zA-Z]|([?\\/])((?:\\\\6|.)+?)\\6)([+-]\\d+)?\\s*(\\D.*)");
    private static final Pattern JUST_START = Pattern.compile("^\\s*(%|\\$|[+-.]?\\d+|\\.|\\^|'[<\\[a-zA-Z]|([?\\/])((?:\\\\2|.)+?)\\2)([+-]\\d+)?\\s*(\\D.*)");
    private static final Pattern JUST_STOP = Pattern.compile("^\\s*[,;]\\s*([+-.]?\\d+|\\.|\\$|'[>\\]a-zA-Z]|([?\\/])((?:\\\\6|.)+?)\\6)([+-]\\d+)?\\s*(\\D.*)");
    private static final Pattern CURRENT_LINE_COMMAND = Pattern.compile("^((t|co(p(y)?)?|m(o(v(e?)?)?)?)(\\s+|\\+).*|d(e(l(e(t(e?)?)?)?)?)?(\\s.*|$)|y(a(n(k?)?)?)?(\\s.*|$))");
    private String definition;
    private String startStr = "";
    private String stopStr = "";
    private String operationStr = "";

    public LineRangeOperationCommand(String definition) {
        this.definition = definition;
        this.parseRangeDefinition();
    }

    public static boolean isLineRangeOperation(String command) {
        return JUST_START.matcher(command).matches() || JUST_STOP.matcher(command).matches();
    }

    public static boolean isCurrentLineOperation(String command) {
        return CURRENT_LINE_COMMAND.matcher(command).matches();
    }

    public String getOperationStr() {
        return this.operationStr;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        LineRange range = this.parseRangeDefinition(editorAdaptor);
        if (range != null) {
            LineWiseOperation operation = this.parseRangeOperation(editorAdaptor);
            if (operation instanceof SubstitutionOperation) {
                SubstitutionOperation substitute = (SubstitutionOperation)operation;
                SubstitutionDefinition definition = substitute.getDefinition();
                if (definition.hasFlag('c')) {
                    editorAdaptor.changeModeSafely("confirm substitution mode", new ConfirmSubstitutionMode.SubstitutionConfirm(definition, range.getStartLine(), range.getEndLine()));
                } else {
                    substitute.execute(editorAdaptor, range);
                }
            } else if (operation != null) {
                operation.execute(editorAdaptor, range);
                CursorService cursorService = editorAdaptor.getCursorService();
                cursorService.setPosition(cursorService.getPosition(), StickyColumnPolicy.ON_CHANGE);
            }
        }
    }

    private void parseRangeDefinition() {
        Matcher matchingRe = START_AND_STOP.matcher(this.definition);
        if (matchingRe.matches()) {
            this.startStr = String.valueOf(matchingRe.group(1)) + (matchingRe.group(4) != null ? matchingRe.group(4) : "");
            this.stopStr = String.valueOf(matchingRe.group(5)) + (matchingRe.group(8) != null ? matchingRe.group(8) : "");
            this.operationStr = matchingRe.group(9);
        } else {
            matchingRe = JUST_START.matcher(this.definition);
            if (matchingRe.matches()) {
                this.stopStr = this.startStr = String.valueOf(matchingRe.group(1)) + (matchingRe.group(4) != null ? matchingRe.group(4) : "");
            } else {
                matchingRe = JUST_STOP.matcher(this.definition);
                if (matchingRe.matches()) {
                    this.stopStr = String.valueOf(matchingRe.group(1)) + (matchingRe.group(4) != null ? matchingRe.group(4) : "");
                }
            }
            this.operationStr = matchingRe.group(5);
        }
        if (this.startStr.equals("%")) {
            this.startStr = "0";
            this.stopStr = "$";
        } else {
            if (this.startStr.length() == 0 || this.startStr.startsWith("+") || this.startStr.startsWith("-")) {
                this.startStr = "." + this.startStr;
            }
            if (this.stopStr.length() == 0 || this.stopStr.startsWith("+") || this.stopStr.startsWith("-")) {
                this.stopStr = "." + this.stopStr;
            }
        }
    }

    public LineRange parseRangeDefinition(EditorAdaptor editorAdaptor) {
        Position startPos = LineAddressParser.parseAddressPosition(this.startStr, editorAdaptor);
        Position stopPos = LineAddressParser.parseAddressPosition(this.stopStr, editorAdaptor);
        if (startPos != null && stopPos != null) {
            return SimpleLineRange.betweenPositions(editorAdaptor, startPos, stopPos);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public LineWiseOperation parseRangeOperation(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        if (!this.operationStr.isEmpty()) ** GOTO lbl5
        editorAdaptor.getUserInterfaceService().setErrorMessage("No operation specified.");
        return null;
lbl-1000:
        // 1 sources

        {
            this.operationStr = this.operationStr.substring(1);
lbl5:
            // 2 sources

            ** while (this.operationStr.startsWith((String)":"))
        }
lbl6:
        // 1 sources

        operation = this.operationStr.charAt(0);
        if (operation == 'y') {
            if (this.operationStr.length() > 2 && this.operationStr.indexOf(32) == this.operationStr.length() - 2) {
                return new YankOperation(this.operationStr.substring(this.operationStr.length() - 1), false);
            }
            return new YankOperation(null, false);
        }
        if (operation == 'd') {
            return DeleteOperation.INSTANCE;
        }
        if (operation == 's' && this.operationStr.startsWith("sort")) {
            return new SortOperation(this.operationStr.substring(4));
        }
        if (operation == 's') {
            try {
                def = new SubstitutionDefinition(this.operationStr, editorAdaptor.getRegisterManager());
            }
            catch (IllegalArgumentException e) {
                throw new CommandExecutionException(e.getMessage());
            }
            return new SubstitutionOperation(def);
        }
        if (operation == 'g' || operation == 'v') {
            return new ExCommandOperation(this.operationStr);
        }
        if (operation == 'r' && this.operationStr.startsWith("ret")) {
            return new RetabOperation(this.operationStr);
        }
        if (operation == 'c' || operation == 't') {
            return new CopyMoveLinesOperation(this.operationStr, false);
        }
        if (operation == 'm') {
            return new CopyMoveLinesOperation(this.operationStr, true);
        }
        if (operation == 'n' && this.operationStr.startsWith("norm")) {
            return new AnonymousMacroOperation(this.operationStr);
        }
        if (operation == '!') {
            return new PipeExternalOperation(this.operationStr);
        }
        if (ReadExternalOperation.isValid(editorAdaptor, this.operationStr)) {
            return new ReadExternalOperation(this.operationStr);
        }
        editorAdaptor.getUserInterfaceService().setErrorMessage("Unknown operation for range: " + this.operationStr);
        return null;
    }
}

