/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.TextObject;

public class LineWiseSelection
extends AbstractSelection {
    private final Position from;
    private final Position to;
    private final TextRange range;

    public LineWiseSelection(EditorAdaptor editor, Position from, Position to) {
        this.from = from;
        this.to = to;
        this.range = StartEndTextRange.lines(editor, from, to);
    }

    @Override
    public String getModeName() {
        return "linewise visual mode";
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorMode, int count) throws CommandExecutionException {
        return this.range;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public TextObject withCount(int count) {
        return this;
    }

    @Override
    public Position getEnd() {
        return this.range.getEnd();
    }

    @Override
    public Position getLeftBound() {
        return this.range.getLeftBound();
    }

    @Override
    public int getModelLength() {
        return this.range.getModelLength();
    }

    @Override
    public Position getRightBound() {
        return this.range.getRightBound();
    }

    @Override
    public Position getStart() {
        return this.range.getStart();
    }

    @Override
    public int getViewLength() {
        return this.range.getViewLength();
    }

    @Override
    public boolean isReversed() {
        return this.range.isReversed();
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.LINES;
    }

    @Override
    public Position getFrom() {
        return this.from;
    }

    @Override
    public Position getTo() {
        return this.to;
    }

    @Override
    public Position getStartMark(EditorAdaptor editorAdaptor) {
        return this.range.getLeftBound();
    }

    @Override
    public Position getEndMark(EditorAdaptor editorAdaptor) {
        Position end = this.range.getRightBound();
        TextContent content = editorAdaptor.getModelContent();
        LineInformation endLine = content.getLineInformationOfOffset(end.getModelOffset());
        int endLineNumber = endLine.getNumber();
        if (this.range.getModelLength() > 0 && endLine.getBeginOffset() == end.getModelOffset()) {
            CursorService cursorService = editorAdaptor.getCursorService();
            LineInformation prevLine = content.getLineInformation(endLineNumber - 1);
            end = cursorService.newPositionForModelOffset(prevLine.getEndOffset());
        }
        return end;
    }

    @Override
    public Selection doReset(EditorAdaptor adaptor, Position from, Position to) {
        return new LineWiseSelection(adaptor, from, to);
    }
}

