/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.FileService;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractMessagesCommand;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;

public class ListMarksCommand
extends AbstractMessagesCommand {
    private String toDisplay;

    public ListMarksCommand() {
        this("");
    }

    public ListMarksCommand(String toDisplay) {
        this.toDisplay = toDisplay;
    }

    @Override
    protected String getMessages(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        List<String> names;
        StringBuilder sb = new StringBuilder();
        CursorService cursor = editorAdaptor.getCursorService();
        FileService files = editorAdaptor.getFileService();
        if (this.toDisplay.length() > 0) {
            this.toDisplay = this.toDisplay.replaceAll(" ", "");
            names = Arrays.asList(this.toDisplay.split("(?!^)"));
        } else {
            Set<String> allNames = cursor.getAllMarks();
            names = new ArrayList<String>(allNames);
        }
        Collections.sort(names);
        sb.append("mark line  col file/text\n");
        for (String name : names) {
            String colNo;
            String lineNo;
            LineInformation line;
            String filename;
            Position mark = cursor.getMark(name);
            if (name.startsWith("x-vrapper-")) continue;
            if (cursor.isGlobalMark(name)) {
                filename = files.getFileNameOfGlobalMark(name);
                line = filename.equals(files.getCurrentFileName()) ? editorAdaptor.getModelContent().getLineInformationOfOffset(mark.getModelOffset()) : null;
            } else if (mark == null) {
                filename = "?";
                line = null;
            } else {
                filename = files.getCurrentFileName();
                line = editorAdaptor.getModelContent().getLineInformationOfOffset(mark.getModelOffset());
            }
            if (line == null) {
                lineNo = "?";
                colNo = "?";
            } else {
                lineNo = String.valueOf(line.getNumber() + 1);
                colNo = String.valueOf(mark.getModelOffset() - line.getBeginOffset());
            }
            sb.append(String.format(" %1s %6s %4s %s\n", name, lineNo, colNo, filename));
        }
        return sb.toString();
    }
}

