/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextObject;

public class MultipliedTextObject
implements TextObject {
    private final int count;
    private final TextObject textObject;

    public MultipliedTextObject(int count, TextObject textObject) {
        this.count = count;
        this.textObject = textObject;
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return this.textObject.getContentType(configuration);
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorMode, int count) throws CommandExecutionException {
        int newCount = 0;
        if (count != 0 || this.count != 0) {
            newCount = (count == 0 ? 1 : count) * (this.count == 0 ? 1 : this.count);
        }
        return this.textObject.getRegion(editorMode, newCount);
    }

    @Override
    public TextObject withCount(int count) {
        return new MultipliedTextObject(count, this.textObject);
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

