/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.SimpleTextOperation;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.InitialContentsHint;

public class NormalLineRangeOperation
extends SimpleTextOperation {
    public static final NormalLineRangeOperation INSTANCE = new NormalLineRangeOperation();

    private NormalLineRangeOperation() {
    }

    @Override
    public TextOperation repetition() {
        return null;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, TextRange region, ContentType contentType) throws CommandExecutionException {
        String endDef;
        if (region.getRightBound().getModelOffset() == editorAdaptor.getModelContent().getTextLength()) {
            endDef = "$";
        } else {
            TextContent model = editorAdaptor.getModelContent();
            int startLine = model.getLineInformationOfOffset(region.getLeftBound().getModelOffset()).getNumber();
            int endLine = model.getLineInformationOfOffset(region.getRightBound().getModelOffset()).getNumber();
            if (contentType == ContentType.LINES) {
                --endLine;
            }
            endDef = ".";
            if (endLine > startLine) {
                endDef = String.valueOf(endDef) + "+" + (endLine - startLine);
            }
        }
        String lineRangeDef = ".";
        if (!endDef.equals(".")) {
            lineRangeDef = String.valueOf(lineRangeDef) + "," + endDef;
        }
        lineRangeDef = String.valueOf(lineRangeDef) + "!";
        editorAdaptor.setPosition(region.getLeftBound(), StickyColumnPolicy.NEVER);
        editorAdaptor.changeModeSafely("command mode", new InitialContentsHint(lineRangeDef));
    }
}

