/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.MotionTextObject;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.motions.Motion;

public class OptionDependentTextObject
extends AbstractTextObject {
    private final TextObject onTrue;
    private final TextObject onFalse;
    private final Configuration.Option<Boolean> option;

    public OptionDependentTextObject(Configuration.Option<Boolean> option, Motion onTrue, Motion onFalse) {
        this.option = option;
        this.onTrue = new MotionTextObject(onTrue);
        this.onFalse = new MotionTextObject(onFalse);
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        if (configuration.get(this.option).booleanValue()) {
            return this.onTrue.getContentType(configuration);
        }
        return this.onFalse.getContentType(configuration);
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (editorAdaptor.getConfiguration().get(this.option).booleanValue()) {
            return this.onTrue.getRegion(editorAdaptor, count);
        }
        return this.onFalse.getRegion(editorAdaptor, count);
    }
}

