/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BlockPasteHelper;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.RegisterContent;

public class PasteAfterCommand
extends CountAwareCommand {
    public static final PasteAfterCommand CURSOR_ON_TEXT = new PasteAfterCommand(false);
    public static final PasteAfterCommand CURSOR_AFTER_TEXT = new PasteAfterCommand(true);
    private boolean placeCursorAfter;

    private PasteAfterCommand(boolean placeCursorAfter) {
        this.placeCursorAfter = placeCursorAfter;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) {
        int position;
        if (count == 0) {
            count = 1;
        }
        CursorService cursorService = editorAdaptor.getCursorService();
        RegisterContent registerContent = editorAdaptor.getRegisterManager().getActiveRegister().getContent();
        String text = registerContent.getText();
        text = VimUtils.replaceNewLines(text, editorAdaptor.getConfiguration().getNewLine());
        TextContent content = editorAdaptor.getModelContent();
        int offset = editorAdaptor.getPosition().getModelOffset();
        LineInformation line = content.getLineInformationOfOffset(offset);
        int lineNo = line.getNumber() + 1;
        switch (registerContent.getPayloadType()) {
            case LINES: {
                if (lineNo < content.getNumberOfLines()) {
                    position = offset = content.getLineInformation(lineNo).getBeginOffset();
                    break;
                }
                offset = content.getTextLength();
                String newLine = editorAdaptor.getConfiguration().getNewLine();
                text = String.valueOf(newLine) + VimUtils.stripLastNewline(text);
                position = offset + newLine.length();
                break;
            }
            case TEXT: 
            case KEY_SEQUENCE: {
                offset = Math.min(line.getEndOffset(), offset + 1);
                position = offset + text.length() * count;
                if (this.placeCursorAfter && text.length() != 0 || line.getLength() <= 0) break;
                --position;
                break;
            }
            case TEXT_RECTANGLE: {
                BlockPasteHelper.execute(editorAdaptor, count, 1, this.placeCursorAfter);
                return;
            }
            default: {
                return;
            }
        }
        try {
            editorAdaptor.getHistory().beginCompoundChange();
            String multipliedText = StringUtils.multiply(text, count);
            content.replace(offset, 0, multipliedText);
            int followingLine = lineNo + StringUtils.countNewlines(text) * count;
            if (registerContent.getPayloadType() == ContentType.LINES && this.placeCursorAfter && followingLine < content.getNumberOfLines()) {
                position = content.getLineInformation(followingLine).getBeginOffset();
            }
            Position start = cursorService.newPositionForModelOffset(offset);
            int tweak = Math.max(1, VimUtils.endsWithNewLine(multipliedText));
            Position end = start.addModelOffset(multipliedText.length() - tweak);
            cursorService.setMark("[", start);
            cursorService.setMark("]", end);
            Position destination = cursorService.newPositionForModelOffset(position);
            editorAdaptor.setPosition(destination, StickyColumnPolicy.ON_CHANGE);
        }
        finally {
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    @Override
    public CountAwareCommand repetition() {
        return this;
    }
}

