/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.RegisterContent;

public class PasteOperation
implements TextOperation {
    public static final PasteOperation INSTANCE = new PasteOperation(true);
    public static final PasteOperation INSTANCE_TEMPVISUAL = new PasteOperation(false);
    private final boolean fixNormalModeCursor;

    private PasteOperation(boolean fixNormalCursor) {
        this.fixNormalModeCursor = fixNormalCursor;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count, TextObject textObject) throws CommandExecutionException {
        try {
            editorAdaptor.getHistory().beginCompoundChange();
            this.doIt(editorAdaptor, count, textObject.getRegion(editorAdaptor, 0), textObject.getContentType(editorAdaptor.getConfiguration()));
        }
        finally {
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    @Override
    public TextOperation repetition() {
        return this;
    }

    protected void doIt(EditorAdaptor editorAdaptor, int count, TextRange range, ContentType contentType) {
        int position;
        if (count == 0) {
            count = 1;
        }
        RegisterContent registerContent = editorAdaptor.getRegisterManager().getActiveRegister().getContent();
        String text = StringUtils.multiply(registerContent.getText(), count);
        String newLine = editorAdaptor.getConfiguration().getNewLine();
        text = VimUtils.replaceNewLines(text, newLine);
        ContentType pastingContentType = registerContent.getPayloadType();
        ContentType selectionContentType = editorAdaptor.getSelection().getContentType(editorAdaptor.getConfiguration());
        TextContent content = editorAdaptor.getModelContent();
        int offset = range.getLeftBound().getModelOffset();
        editorAdaptor.getRegisterManager().activateDefaultRegister();
        DeleteOperation.doIt(editorAdaptor, range, contentType);
        if (selectionContentType == ContentType.LINES || pastingContentType == ContentType.LINES) {
            if (pastingContentType != ContentType.LINES) {
                text = String.valueOf(text) + newLine;
            } else if (selectionContentType != ContentType.LINES) {
                text = String.valueOf(newLine) + text;
            }
            content.replace(offset, 0, text);
            LineInformation firstPastedLine = content.getLineInformationOfOffset(offset + 1);
            position = VimUtils.getFirstNonWhiteSpaceOffset(content, firstPastedLine);
        } else {
            position = offset + text.length();
            if (this.fixNormalModeCursor) {
                --position;
            }
            content.replace(offset, 0, text);
        }
        Position destination = editorAdaptor.getCursorService().newPositionForModelOffset(position);
        editorAdaptor.setPosition(destination, StickyColumnPolicy.ON_CHANGE);
    }
}

