/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.Register;

public class PasteRegisterCommand
extends CountIgnoringNonRepeatableCommand {
    public static final PasteRegisterCommand PASTE_LAST_INSERT = new PasteRegisterCommand(".");
    private String registerName;

    public PasteRegisterCommand(String registerName) {
        this.registerName = registerName;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Register reg = editorAdaptor.getRegisterManager().getRegister(this.registerName);
        String text = reg.getContent().getText();
        if ((text = VimUtils.replaceNewLines(text, editorAdaptor.getConfiguration().getNewLine())).length() > 0) {
            TextContent content = editorAdaptor.getModelContent();
            Selection currentSelection = editorAdaptor.getSelection();
            if (currentSelection.getModelLength() > 0) {
                content.replace(currentSelection.getLeftBound().getModelOffset(), currentSelection.getModelLength(), "");
            }
            int offset = editorAdaptor.getCursorService().getPosition().getModelOffset();
            int position = offset + text.length();
            content.replace(offset, 0, text);
            Position destination = editorAdaptor.getCursorService().newPositionForModelOffset(position);
            editorAdaptor.setPosition(destination, StickyColumnPolicy.ON_CHANGE);
        }
    }
}

