/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.DelimitedText;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.FindQuoteMotion;

public class QuoteDelimitedText
implements DelimitedText {
    private char delimiter;

    public QuoteDelimitedText(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public TextRange leftDelimiter(int offset, EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        FindQuoteMotion leftMotion = new FindQuoteMotion(this.delimiter, true);
        int leftOffset = leftMotion.destination(offset, editorAdaptor.getModelContent(), count);
        Position left = editorAdaptor.getCursorService().newPositionForModelOffset(leftOffset);
        return new StartEndTextRange(left, left.addModelOffset(1));
    }

    @Override
    public TextRange rightDelimiter(int offset, EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        TextRange left = this.leftDelimiter(offset, editorAdaptor, count);
        FindQuoteMotion rightMotion = new FindQuoteMotion(this.delimiter, left.getLeftBound().getModelOffset() + 1);
        Position right = ((CountAwareMotion)rightMotion).destination(editorAdaptor, count);
        return new StartEndTextRange(right, right.addModelOffset(1));
    }
}

