/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.ProcessHelper;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class ReadExternalOperation
extends AbstractLinewiseOperation {
    private static final Pattern READ_PIPE_RE = Pattern.compile("^\\s*r\\s*!\\s*(\\S.*)");
    private static final Pattern FILENAME_RE = Pattern.compile("(?<!\\\\)%");
    private String externalCommand;

    public ReadExternalOperation(String cmdLine) {
        Matcher matcher = READ_PIPE_RE.matcher(cmdLine);
        if (matcher.matches()) {
            this.externalCommand = matcher.group(1);
        }
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.singleLine(editorAdaptor, currentPos);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        editorAdaptor.getHistory().beginCompoundChange();
        try {
            this.doIt(editorAdaptor, lineRange.getRegion(editorAdaptor, 0));
        }
        finally {
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    @Override
    public TextOperation repetition() {
        return this;
    }

    protected void doIt(EditorAdaptor editorAdaptor, TextRange range) {
        if (this.externalCommand.isEmpty()) {
            editorAdaptor.getUserInterfaceService().setErrorMessage("syntax error for 'r!'");
        }
        if (this.externalCommand.contains("%")) {
            Matcher matcher = FILENAME_RE.matcher(this.externalCommand);
            if (matcher.find()) {
                String currentfile = editorAdaptor.getFileService().getCurrentFileName();
                this.externalCommand = this.externalCommand.replaceAll("%", currentfile);
            } else {
                this.externalCommand = this.externalCommand.replaceAll("\\\\%", "%");
            }
        }
        try {
            Process p = ProcessHelper.start(ProcessHelper.splitArgs(this.externalCommand));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String s = ProcessHelper.ReadProcessOutput(stdInput);
            if (p.waitFor() != 0) {
                StringBuffer errorMsg = new StringBuffer();
                while ((s = stdError.readLine()) != null) {
                    errorMsg.append('\n');
                    errorMsg.append(s);
                }
                VrapperLog.error("r!<cmd> failed with code " + p.exitValue() + " command: " + this.externalCommand + errorMsg);
                editorAdaptor.getUserInterfaceService().setErrorMessage("r!<cmd> failed with code " + p.exitValue() + " command: " + this.externalCommand + " (Check error log).");
            } else {
                int position = range.getRightBound().getModelOffset();
                editorAdaptor.getModelContent().replace(position, 0, s);
                editorAdaptor.getCursorService().setPosition(range.getRightBound(), StickyColumnPolicy.ON_CHANGE);
            }
        }
        catch (Exception e) {
            VrapperLog.error("r!<cmd> failed : " + e.getMessage(), e);
            editorAdaptor.getUserInterfaceService().setErrorMessage("r!<cmd> failed : " + e.getMessage());
        }
    }

    public static boolean isValid(EditorAdaptor vim, String command) {
        return READ_PIPE_RE.matcher(command).matches();
    }
}

