/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.SubstitutionOperation;

public class RepeatLastSubstitutionCommand
extends CountAwareCommand {
    public static final RepeatLastSubstitutionCommand CURRENT_LINE_ONLY = new RepeatLastSubstitutionCommand(true);
    public static final RepeatLastSubstitutionCommand GLOBALLY = new RepeatLastSubstitutionCommand(false);
    private boolean currentLineOnly;

    private RepeatLastSubstitutionCommand(boolean currentLineOnly) {
        this.currentLineOnly = currentLineOnly;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        SubstitutionOperation substitution = editorAdaptor.getRegisterManager().getLastSubstitution();
        if (substitution == null) {
            return;
        }
        SimpleLineRange range = this.currentLineOnly ? SimpleLineRange.singleLine(editorAdaptor, editorAdaptor.getPosition()) : SimpleLineRange.entireFile(editorAdaptor);
        substitution.execute(editorAdaptor, range);
    }

    @Override
    public CountAwareCommand repetition() {
        return this;
    }
}

