/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.LocalConfiguration;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AbstractModelSideCommand;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public abstract class ReplaceCommand
extends AbstractModelSideCommand {
    public static final Function<Command, KeyStroke> KEYSTROKE_CONVERTER = new Function<Command, KeyStroke>(){

        @Override
        public Command call(KeyStroke arg) {
            if (SpecialKey.RETURN.equals((Object)arg.getSpecialKey())) {
                return Newline.INSTANCE;
            }
            return new Character(arg.getCharacter());
        }
    };

    @Override
    protected int execute(TextContent c, int offset, int count) {
        int targetOffset = offset + count - 1;
        LineInformation line = c.getLineInformationOfOffset(offset);
        if (targetOffset < line.getEndOffset()) {
            return this.replace(c, offset, count, targetOffset);
        }
        return offset;
    }

    abstract int replace(TextContent var1, int var2, int var3, int var4);

    private static class Character
    extends ReplaceCommand {
        private final char replacement;

        public Character(char replacement) {
            this.replacement = replacement;
        }

        @Override
        protected int replace(TextContent c, int offset, int count, int targetOffset) {
            String s = StringUtils.multiply("" + this.replacement, count);
            c.replace(offset, s.length(), s);
            return targetOffset;
        }
    }

    private static class Newline
    extends ReplaceCommand {
        private static final Newline INSTANCE = new Newline();
        private String newLine;
        private boolean smartIndent;
        private boolean autoIndent;

        private Newline() {
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            LocalConfiguration conf = editorAdaptor.getConfiguration();
            this.newLine = conf.getNewLine();
            this.smartIndent = conf.get(Options.SMART_INDENT);
            this.autoIndent = conf.get(Options.AUTO_INDENT);
            super.execute(editorAdaptor);
        }

        @Override
        int replace(TextContent c, int offset, int count, int targetOffset) {
            LineInformation line = c.getLineInformationOfOffset(offset);
            if (this.smartIndent) {
                c.replace(offset, targetOffset - offset + 1, "");
                c.smartInsert(offset, this.newLine);
            } else {
                String indent = this.autoIndent ? VimUtils.getIndent(c, line) : "";
                c.replace(offset, targetOffset - offset + 1, String.valueOf(this.newLine) + indent);
            }
            LineInformation nextLine = c.getLineInformation(line.getNumber() + 1);
            return VimUtils.getFirstNonWhiteSpaceOffset(c, nextLine);
        }
    }

    public static class Visual
    extends ReplaceCommand {
        private final char replaceChar;
        protected int selectionOffset;
        protected String selectionText;
        public static final Function<Command, KeyStroke> VISUAL_KEYSTROKE = new Function<Command, KeyStroke>(){

            @Override
            public Command call(KeyStroke arg) {
                return new Visual(arg.getCharacter());
            }
        };

        public Visual(char replacement) {
            this.replaceChar = replacement;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            TextRange selectionRange = editorAdaptor.getSelection().getRegion(editorAdaptor, 0);
            this.selectionOffset = selectionRange.getLeftBound().getModelOffset();
            this.selectionText = editorAdaptor.getModelContent().getText(selectionRange);
            this.replace(editorAdaptor.getModelContent(), this.selectionOffset, 1, this.selectionOffset);
            editorAdaptor.changeMode("normal mode", new ModeSwitchHint[0]);
        }

        @Override
        protected int replace(TextContent c, int offset, int count, int targetOffset) {
            String s = "";
            int i = 0;
            while (i < this.selectionText.length()) {
                s = String.valueOf(s) + (VimUtils.isNewLine("" + this.selectionText.charAt(i)) ? this.selectionText.charAt(i) : this.replaceChar);
                ++i;
            }
            c.replace(this.selectionOffset, this.selectionText.length(), s);
            return this.selectionOffset;
        }
    }

    public static class VisualBlock
    extends Visual {
        public static final Function<Command, KeyStroke> VISUALBLOCK_KEYSTROKE = new Function<Command, KeyStroke>(){

            @Override
            public Command call(KeyStroke arg) {
                return new VisualBlock(arg.getCharacter());
            }
        };

        public VisualBlock(char replacement) {
            super(replacement);
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            HistoryService history = editorAdaptor.getHistory();
            history.beginCompoundChange();
            history.lock("block-action");
            TextContent textContent = editorAdaptor.getModelContent();
            Selection selection = editorAdaptor.getSelection();
            Position selectionStart = selection.getFrom();
            Position selectionEnd = selection.getTo();
            CursorService cursorService = editorAdaptor.getCursorService();
            editorAdaptor.setSelection(null);
            BlockWiseSelection.TextBlock textBlock = BlockWiseSelection.getTextBlock(selectionStart, selectionEnd, textContent, cursorService);
            int line = textBlock.startLine;
            while (line <= textBlock.endLine) {
                Position start = cursorService.getPositionByVisualOffset(line, textBlock.startVisualOffset);
                if (start != null) {
                    int startOfs = start.getModelOffset();
                    Position end = cursorService.getPositionByVisualOffset(line, textBlock.endVisualOffset);
                    int endOfs = end == null ? textContent.getLineInformation(line).getEndOffset() : end.addModelOffset(1).getModelOffset();
                    this.selectionText = textContent.getText(startOfs, endOfs - startOfs);
                    this.selectionOffset = startOfs;
                    this.replace(textContent, startOfs, 1, endOfs);
                }
                ++line;
            }
            history.unlock("block-action");
            history.endCompoundChange();
            editorAdaptor.changeMode("normal mode", new ModeSwitchHint[0]);
        }
    }
}

