/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AbstractSelection;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.DelimitedTextObject;
import net.sourceforge.vrapper.vim.commands.LineWiseSelection;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SimpleSelection;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;

public class SelectTextObjectCommand
extends CountAwareCommand {
    private final TextObject textObject;

    public SelectTextObjectCommand(TextObject textObject) {
        this.textObject = textObject;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        String newMode;
        AbstractSelection selection;
        Selection oldSelection = editorAdaptor.getSelection();
        TextRange region = this.textObject.getRegion(editorAdaptor, count);
        int orgCount = count;
        while (this.textObject instanceof DelimitedTextObject && oldSelection.getLeftBound().getModelOffset() <= region.getLeftBound().getModelOffset() && oldSelection.getRightBound().getModelOffset() >= region.getRightBound().getModelOffset()) {
            if (count > orgCount + 10) break;
            region = this.textObject.getRegion(editorAdaptor, ++count);
        }
        switch (this.textObject.getContentType(editorAdaptor.getConfiguration())) {
            case TEXT_RECTANGLE: {
                selection = new BlockWiseSelection(editorAdaptor, region.getStart(), region.getEnd());
                newMode = "block visual mode";
                break;
            }
            case LINES: {
                selection = region instanceof LineWiseSelection ? (LineWiseSelection)region : new LineWiseSelection(editorAdaptor, region.getStart(), region.getEnd());
                newMode = "linewise visual mode";
                break;
            }
            case TEXT: {
                String selectionOption = editorAdaptor.getConfiguration().get(Options.SELECTION);
                boolean isInclusive = "inclusive".equals(selectionOption);
                selection = new SimpleSelection(editorAdaptor.getCursorService(), isInclusive, region);
                newMode = "visual mode";
                break;
            }
            default: {
                throw new CommandExecutionException("WTF");
            }
        }
        Position caretPos = selection.getTo();
        if (caretPos.getViewOffset() < 0) {
            editorAdaptor.getViewportService().exposeModelPosition(caretPos);
        }
        editorAdaptor.setPosition(caretPos, StickyColumnPolicy.ON_CHANGE);
        editorAdaptor.setSelection(selection);
        editorAdaptor.changeMode(newMode, AbstractVisualMode.FIX_SELECTION_HINT);
    }

    @Override
    public CountAwareCommand repetition() {
        return null;
    }
}

