/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.SimpleSelection;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextObjectCommand;

public class SelectionBasedTextObjectCommand
extends TextObjectCommand {
    protected Command command;

    public SelectionBasedTextObjectCommand(Command command, TextObject textObject) {
        super(textObject);
        this.command = command;
    }

    @Override
    protected void execute(EditorAdaptor editorMode, TextRange range, ContentType contentType) throws CommandExecutionException {
        editorMode.setSelection(new SimpleSelection(range));
        this.command.execute(editorMode);
        editorMode.setSelection(null);
    }

    @Override
    public CountAwareCommand repetition() {
        Command wrappedRepetition = (Command)this.command.repetition();
        if (wrappedRepetition != null) {
            return new SelectionBasedTextObjectCommand(wrappedRepetition, this.textObject);
        }
        return null;
    }
}

