/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AbstractSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.TextObject;

public class SimpleSelection
extends AbstractSelection {
    private final TextRange range;
    private Position from;
    private Position to;

    public SimpleSelection(Position selectionStartCaretPos, Position selectionEndCaretPos, TextRange range) {
        this.from = selectionStartCaretPos;
        this.to = selectionEndCaretPos;
        this.range = range;
    }

    public SimpleSelection(CursorService cursorService, boolean isIncusive, TextRange range) {
        this.range = range;
        Position startSel = range.getStart();
        Position endSel = range.getEnd();
        this.from = startSel;
        this.to = endSel;
        if (range.getModelLength() > 0 && isIncusive) {
            if (range.isReversed()) {
                int modelOffset = startSel.getModelOffset();
                this.from = cursorService.shiftPositionForModelOffset(modelOffset, -1, true);
            } else {
                int modelOffset = endSel.getModelOffset();
                this.to = cursorService.shiftPositionForModelOffset(modelOffset, -1, true);
            }
        }
    }

    public SimpleSelection(TextRange range) {
        this.range = range;
        if (range != null) {
            this.from = range.getStart();
            this.to = range.getEnd();
        }
    }

    @Override
    public String getModeName() {
        return "visual mode";
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.TEXT;
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorMode, int count) throws CommandExecutionException {
        return this.range;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public TextObject withCount(int count) {
        return this;
    }

    @Override
    public Position getEnd() {
        return this.range.getEnd();
    }

    @Override
    public Position getLeftBound() {
        return this.range.getLeftBound();
    }

    @Override
    public int getModelLength() {
        return this.range.getModelLength();
    }

    @Override
    public Position getRightBound() {
        return this.range.getRightBound();
    }

    @Override
    public Position getStart() {
        return this.range.getStart();
    }

    @Override
    public int getViewLength() {
        return this.range.getViewLength();
    }

    @Override
    public boolean isReversed() {
        return this.range.isReversed();
    }

    @Override
    public Position getFrom() {
        return this.from;
    }

    @Override
    public Position getTo() {
        return this.to;
    }

    @Override
    public Position getStartMark(EditorAdaptor defaultEditorAdaptor) {
        if (this.range.isReversed()) {
            return this.to;
        }
        return this.from;
    }

    @Override
    public Position getEndMark(EditorAdaptor defaultEditorAdaptor) {
        if (this.range.isReversed()) {
            return this.from;
        }
        return this.to;
    }

    public String toString() {
        String caretInfo = "";
        if (this.range != null && this.to != null && this.range.getEnd() != this.to) {
            caretInfo = " @ M" + this.to.getModelOffset() + "/" + this.to.getViewOffset() + "V";
        }
        return "SimpleSelection( " + String.valueOf(this.range) + caretInfo + " )";
    }

    @Override
    public Selection doReset(EditorAdaptor adaptor, Position from, Position to) {
        boolean isSelectionInclusive = "inclusive".equals(adaptor.getConfiguration().get(Options.SELECTION));
        if (isSelectionInclusive) {
            return new SimpleSelection(from, to, StartEndTextRange.inclusive(adaptor.getCursorService(), from, to));
        }
        return new SimpleSelection(from, to, StartEndTextRange.exclusive(from, to));
    }
}

