/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.SubstitutionDefinition;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.TextOperation;

public class SubstitutionOperation
extends AbstractLinewiseOperation {
    private SubstitutionDefinition subDef;

    public SubstitutionOperation(SubstitutionDefinition substitution) {
        this.subDef = substitution;
    }

    public SubstitutionDefinition getDefinition() {
        return this.subDef;
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.singleLine(editorAdaptor, currentPos);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange range) throws CommandExecutionException {
        TextContent model = editorAdaptor.getModelContent();
        int numReplaces = 0;
        int lineReplaceCount = 0;
        if (range.getStartLine() == range.getEndLine()) {
            LineInformation currentLine = model.getLineInformation(range.getStartLine());
            editorAdaptor.getHistory().beginCompoundChange();
            numReplaces = this.performReplace(currentLine, this.subDef.find, this.subDef.replace, this.subDef.flags, editorAdaptor);
            editorAdaptor.getHistory().endCompoundChange();
        } else {
            int lineChanges = 0;
            int endLine = range.getEndLine();
            int totalLines = model.getNumberOfLines();
            editorAdaptor.getHistory().beginCompoundChange();
            int i = range.getStartLine();
            while (i <= endLine) {
                LineInformation line = model.getLineInformation(i);
                lineChanges = this.performReplace(line, this.subDef.find, this.subDef.replace, this.subDef.flags, editorAdaptor);
                if (lineChanges > 0) {
                    ++lineReplaceCount;
                }
                numReplaces += lineChanges;
                int lineDiff = model.getNumberOfLines() - totalLines;
                if (lineDiff > 0) {
                    i += lineDiff;
                    endLine += lineDiff;
                    totalLines += lineDiff;
                }
                ++i;
            }
            editorAdaptor.getHistory().endCompoundChange();
        }
        if (numReplaces == 0) {
            editorAdaptor.getUserInterfaceService().setErrorMessage("'" + this.subDef.find + "' not found");
        } else {
            String message = String.valueOf(numReplaces) + " ";
            message = String.valueOf(message) + (this.subDef.flags.contains("n") ? "matches" : "substitutions");
            message = lineReplaceCount > 1 ? String.valueOf(message) + " on " + lineReplaceCount + " lines" : String.valueOf(message) + " on 1 line";
            editorAdaptor.getUserInterfaceService().setInfoMessage(message);
        }
        editorAdaptor.getRegisterManager().setLastSubstitution(this);
    }

    private int performReplace(LineInformation line, String find, String replace, String flags, EditorAdaptor editorAdaptor) {
        if (find.equals("^")) {
            replace = this.convertToPlatformNewline(editorAdaptor, replace);
            editorAdaptor.getModelContent().replace(line.getBeginOffset(), 0, replace);
            return 1;
        }
        if (find.equals("$")) {
            replace = this.convertToPlatformNewline(editorAdaptor, replace);
            editorAdaptor.getModelContent().replace(line.getEndOffset(), 0, replace);
            return 1;
        }
        int start = line.getBeginOffset();
        int end = line.getEndOffset();
        if (find.contains("\\%V")) {
            find = find.replaceAll("\\\\%V", "");
            Selection selection = editorAdaptor.getSelection();
            if (selection != null) {
                start = selection.getLeftBound().getModelOffset();
                end = selection.getRightBound().getModelOffset();
            }
        }
        SearchAndReplaceService searchAndReplace = editorAdaptor.getSearchAndReplaceService();
        return searchAndReplace.replace(start, end, find, replace, flags);
    }

    private String convertToPlatformNewline(EditorAdaptor editorAdaptor, String inputString) {
        String platformNewline = editorAdaptor.getConfiguration().getNewLine();
        String result = inputString.replaceAll("((^|[^\\\\])(\\\\\\\\)*)(\\\\R)", "$1" + platformNewline);
        return result;
    }

    @Override
    public TextOperation repetition() {
        return this;
    }
}

