/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class SwapBlockwiseSelectionSidesCommand
extends CountIgnoringNonRepeatableCommand {
    final SwapMode mode;
    public static final SwapBlockwiseSelectionSidesCommand DIAGONAL_INSTANCE = new SwapBlockwiseSelectionSidesCommand(SwapMode.DIAGONAL);
    public static final SwapBlockwiseSelectionSidesCommand HORIZONTAL_INSTANCE = new SwapBlockwiseSelectionSidesCommand(SwapMode.HORIZONTAL);

    private SwapBlockwiseSelectionSidesCommand(SwapMode mode) {
        this.mode = mode;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) {
        CursorService cs = editorAdaptor.getCursorService();
        TextContent mc = editorAdaptor.getModelContent();
        Selection sel = editorAdaptor.getSelection();
        if (sel.getModelLength() == 1) {
            return;
        }
        Position newStartPos = sel.getTo();
        Position newEndPos = sel.getFrom();
        switch (this.mode) {
            case DIAGONAL: {
                break;
            }
            case HORIZONTAL: {
                int startVOffs = cs.getVisualOffset(sel.getStart());
                int endVOffs = cs.getVisualOffset(sel.getEnd());
                LineInformation startLine = mc.getLineInformationOfOffset(sel.getStart().getModelOffset());
                LineInformation endLine = mc.getLineInformationOfOffset(sel.getEnd().getModelOffset());
                newStartPos = cs.getPositionByVisualOffset(startLine.getNumber(), endVOffs);
                newEndPos = cs.getPositionByVisualOffset(endLine.getNumber(), startVOffs);
                if (newStartPos == null) {
                    newStartPos = cs.newPositionForModelOffset(startLine.getEndOffset());
                }
                if (newEndPos != null) break;
                newEndPos = cs.newPositionForModelOffset(endLine.getEndOffset());
            }
        }
        MotionCommand.gotoAndChangeViewPort(editorAdaptor, newEndPos, StickyColumnPolicy.ON_CHANGE);
        editorAdaptor.setSelection(sel.reset(editorAdaptor, newStartPos, newEndPos));
    }

    private static enum SwapMode {
        DIAGONAL,
        HORIZONTAL;

    }
}

