/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SimpleSelection;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class SwapSelectionSidesCommand
extends CountIgnoringNonRepeatableCommand {
    public static final SwapSelectionSidesCommand INSTANCE = new SwapSelectionSidesCommand();

    private SwapSelectionSidesCommand() {
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) {
        String selectionOption = editorAdaptor.getConfiguration().get(Options.SELECTION);
        boolean isSelectionExclusive = selectionOption.equals("exclusive");
        Selection selection = editorAdaptor.getSelection();
        if (selection.getModelLength() == 1 && !isSelectionExclusive) {
            return;
        }
        MotionCommand.gotoAndChangeViewPort(editorAdaptor, selection.getFrom(), StickyColumnPolicy.ON_CHANGE);
        editorAdaptor.setSelection(new SimpleSelection(selection.getTo(), selection.getFrom(), (TextRange)new StartEndTextRange(selection.getEnd(), selection.getStart())));
    }
}

