/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.MultiplicableCountedCommand;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class TextOperationTextObjectCommand
extends CountAwareCommand {
    private final TextOperation command;
    protected TextObject textObject;

    public TextOperationTextObjectCommand(TextOperation command, TextObject textObject) {
        this.command = command;
        this.textObject = textObject;
    }

    @Override
    public CountAwareCommand repetition() {
        TextOperation wrappedRepetition = this.command.repetition();
        if (wrappedRepetition != null) {
            return new TextOperationTextObjectCommand(wrappedRepetition, this.textObject);
        }
        return null;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        this.command.execute(editorAdaptor, count, this.textObject);
        CursorService cursorService = editorAdaptor.getCursorService();
        cursorService.setPosition(cursorService.getPosition(), StickyColumnPolicy.ON_CHANGE);
    }

    @Override
    public Command withCount(int count) {
        return new MultiplicableCountedCommand(count, this);
    }
}

