/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.SimpleRepeatableCommand;

public class VimCommandSequence
extends SimpleRepeatableCommand {
    private final List<Command> commands = new ArrayList<Command>();

    public VimCommandSequence(Command ... commands) {
        Command[] commandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            Command cmd = commandArray[n2];
            if (cmd != null) {
                this.commands.add(cmd);
            }
            ++n2;
        }
    }

    @Override
    public void execute(EditorAdaptor editorMode) throws CommandExecutionException {
        HistoryService history = editorMode.getHistory();
        try {
            history.beginCompoundChange();
            history.lock();
            for (Command command : this.commands) {
                command.execute(editorMode);
            }
        }
        finally {
            history.unlock();
            history.endCompoundChange();
        }
    }

    @Override
    public Command repetition() {
        Command[] repeated = new Command[this.commands.size()];
        int i = 0;
        while (i < this.commands.size()) {
            Command cmd = this.commands.get(i);
            Command rep = (Command)cmd.repetition();
            repeated[i] = rep != null ? rep : cmd;
            ++i;
        }
        return new VimCommandSequence(repeated);
    }

    public String toString() {
        return String.format("seq(%s)", StringUtils.join(", ", this.commands));
    }
}

