/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.AbstractModelSideMotion;

public class FindBalancedMotion
extends AbstractModelSideMotion {
    protected final char target;
    protected final char pair;
    protected boolean upToTarget;
    protected boolean backwards;
    protected boolean ignoreEscape;

    public FindBalancedMotion(char target, char pair, boolean upToTarget, boolean backwards, boolean ignoreEscape) {
        this.target = target;
        this.pair = pair;
        this.upToTarget = upToTarget;
        this.backwards = backwards;
        this.ignoreEscape = ignoreEscape;
    }

    @Override
    protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
        int end = this.getEndSearchOffset(content, offset);
        int step = this.backwards ? -1 : 1;
        int depth = count;
        while (!(this.backwards ? offset <= end : offset >= end)) {
            char current = content.getText(offset += step, 1).charAt(0);
            if (current == this.target && !this.isEscaped(content, offset)) {
                --depth;
            } else if (current == this.pair && !this.isEscaped(content, offset)) {
                ++depth;
            }
            if (depth == 0) break;
        }
        if (offset >= content.getTextLength() || depth != 0 || content.getText(offset, 1).charAt(0) != this.target) {
            throw new CommandExecutionException("'" + this.target + "' not found");
        }
        if (!this.upToTarget) {
            offset -= step;
        }
        return offset;
    }

    protected boolean isEscaped(TextContent content, int offset) {
        if (offset == 0 || this.ignoreEscape) {
            return false;
        }
        return content.getText(offset - 1, 1).charAt(0) == '\\';
    }

    protected int getEndSearchOffset(TextContent content, int offset) {
        return this.backwards ? 0 : content.getTextLength() - 1;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return this.backwards ? BorderPolicy.EXCLUSIVE : BorderPolicy.INCLUSIVE;
    }
}

