/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.FindBalancedMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.NavigatingMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class FindCharMotion
extends FindBalancedMotion
implements NavigatingMotion {
    protected boolean isRepetition;
    private Motion registrator = new CountAwareMotion(){

        @Override
        public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            editorAdaptor.getRegisterManager().setLastFindCharMotion(FindCharMotion.this.repetition());
            return FindCharMotion.this.destination(editorAdaptor, count);
        }

        @Override
        public BorderPolicy borderPolicy() {
            return FindCharMotion.this.borderPolicy();
        }

        @Override
        public StickyColumnPolicy stickyColumnPolicy() {
            return FindCharMotion.this.stickyColumnPolicy();
        }

        @Override
        public <T> T getAdapter(Class<T> type) {
            return FindCharMotion.this.getAdapter(type);
        }
    };

    public static Function<Motion, KeyStroke> keyConverter(final boolean upToTarget, final boolean reversed) {
        return new Function<Motion, KeyStroke>(){

            @Override
            public Motion call(KeyStroke keyStroke) {
                return new FindCharMotion(keyStroke.getCharacter(), upToTarget, reversed).registrator;
            }
        };
    }

    public FindCharMotion(char target, boolean upToTarget, boolean reversed) {
        super(target, '\u0000', upToTarget, reversed, true);
    }

    @Override
    public FindCharMotion repetition() {
        FindCharMotion repetition = new FindCharMotion(this.target, this.upToTarget, this.backwards);
        repetition.isRepetition = true;
        return repetition;
    }

    @Override
    public FindCharMotion reverse() {
        return new FindCharMotion(this.target, this.upToTarget, !this.backwards);
    }

    @Override
    public boolean isBackward() {
        return this.backwards;
    }

    @Override
    protected int getEndSearchOffset(TextContent content, int offset) {
        LineInformation line = content.getLineInformationOfOffset(offset);
        int end = this.backwards ? line.getBeginOffset() : line.getEndOffset() - 1;
        return end;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Position dest = super.destination(editorAdaptor, count);
        if (this.isRepetition && !this.upToTarget && editorAdaptor.getPosition().getModelOffset() == dest.getModelOffset()) {
            Position originalPos = dest;
            Position tweakPos = dest.addModelOffset(this.backwards ? -1 : 1);
            try {
                editorAdaptor.setPosition(tweakPos, StickyColumnPolicy.NEVER);
                dest = super.destination(editorAdaptor, count);
            }
            catch (CommandExecutionException commandExecutionException) {
                editorAdaptor.setPosition(originalPos, StickyColumnPolicy.NEVER);
            }
        }
        return dest;
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        if (NavigatingMotion.class.equals(type)) {
            return (T)this;
        }
        if (FindCharMotion.class.equals(type)) {
            return (T)this;
        }
        return super.getAdapter(type);
    }
}

