/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class GoToEditLocation
extends CountAwareMotion {
    public static final Motion FORWARD = new GoToEditLocation(true);
    public static final Motion BACKWARDS = new GoToEditLocation(false);
    private boolean forward;

    private GoToEditLocation(boolean forward) {
        this.forward = forward;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Position markPos;
        if (count == 0) {
            count = 1;
        }
        if ((markPos = this.forward ? editorAdaptor.getCursorService().getNextChangeLocation(count) : editorAdaptor.getCursorService().getPrevChangeLocation(count)) == null) {
            throw new CommandExecutionException(this.forward ? "At end of changelist" : "At start of changelist");
        }
        return markPos;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.EXCLUSIVE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    @Override
    public boolean isJump() {
        return true;
    }
}

