/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class GoToLineMotion
extends CountAwareMotion {
    public static Motion FIRST_LINE = new GoToLineMotion();
    public static Motion LAST_LINE = new GoToLineMotion(){

        @Override
        protected int defaultLineNo(TextContent content) {
            if (content.getTextLength() == 0) {
                return 0;
            }
            int lastChar = content.getTextLength() - 1;
            int number = content.getLineInformationOfOffset(lastChar).getNumber();
            if (content.getText(lastChar, 1).equals("\n")) {
                ++number;
            }
            return number;
        }
    };

    protected GoToLineMotion() {
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        int lineNo;
        TextContent content = editorAdaptor.getModelContent();
        int n = lineNo = count == 0 ? this.defaultLineNo(content) : count - 1;
        if (lineNo > content.getNumberOfLines()) {
            lineNo = content.getNumberOfLines();
        }
        LineInformation line = null;
        try {
            line = content.getLineInformation(lineNo);
        }
        catch (RuntimeException runtimeException) {
            line = content.getLineInformation(--lineNo);
        }
        int offset = VimUtils.getFirstNonWhiteSpaceOffset(content, line);
        return editorAdaptor.getCursorService().newPositionForModelOffset(offset);
    }

    protected int defaultLineNo(TextContent content) {
        return 0;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.LINE_WISE;
    }

    @Override
    public boolean isJump() {
        return true;
    }
}

