/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.AbstractMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class GoToMarkMotion
extends AbstractMotion {
    public static final Function<Motion, KeyStroke> LINEWISE_CONVERTER = new Function<Motion, KeyStroke>(){

        @Override
        public Motion call(KeyStroke arg) {
            return new GoToMarkMotion(true, String.valueOf(arg.getCharacter()));
        }
    };
    public static final Function<Motion, KeyStroke> CHARWISE_CONVERTER = new Function<Motion, KeyStroke>(){

        @Override
        public Motion call(KeyStroke arg) {
            return new GoToMarkMotion(false, String.valueOf(arg.getCharacter()));
        }
    };
    private final boolean lineWise;
    private final String id;

    public GoToMarkMotion(boolean lineWise, String id) {
        this.lineWise = lineWise;
        this.id = id;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Position markPos = editorAdaptor.getCursorService().getMark(this.id);
        if (markPos == null) {
            throw new CommandExecutionException("Mark not set");
        }
        if (this.lineWise) {
            TextContent tc = editorAdaptor.getModelContent();
            LineInformation line = tc.getLineInformationOfOffset(markPos.getModelOffset());
            int offset = VimUtils.getFirstNonWhiteSpaceOffset(tc, line);
            editorAdaptor.getCursorService().setMark("'", editorAdaptor.getPosition());
            return editorAdaptor.getCursorService().newPositionForModelOffset(offset);
        }
        return markPos;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public Motion withCount(int count) {
        return this;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return this.lineWise ? BorderPolicy.LINE_WISE : BorderPolicy.EXCLUSIVE;
    }

    @Override
    public boolean isJump() {
        return true;
    }
}

