/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.motions.AbstractModelSideMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class LineStartMotion
extends AbstractModelSideMotion {
    public static final LineStartMotion NON_WHITESPACE = new LineStartMotion(true);
    public static final LineStartMotion COLUMN0 = new LineStartMotion(false);
    private final boolean goToFirstNonWS;

    private LineStartMotion(boolean goToFirstNonWS) {
        this.goToFirstNonWS = goToFirstNonWS;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.EXCLUSIVE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.RESET_EOL;
    }

    @Override
    protected int destination(int position, TextContent content, int count) {
        LineInformation lineInfo = content.getLineInformationOfOffset(position);
        int result = lineInfo.getBeginOffset();
        if (this.goToFirstNonWS) {
            int indent = VimUtils.getIndent(content, lineInfo).length();
            result += indent;
        }
        return result;
    }
}

