/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.AbstractModelSideMotion;

public class MethodDeclarationMotion
extends AbstractModelSideMotion {
    public static final MethodDeclarationMotion NEXT_START = new MethodDeclarationMotion(false, true);
    public static final MethodDeclarationMotion PREV_START = new MethodDeclarationMotion(true, true);
    public static final MethodDeclarationMotion NEXT_END = new MethodDeclarationMotion(false, false);
    public static final MethodDeclarationMotion PREV_END = new MethodDeclarationMotion(true, false);
    public boolean backwards;
    public boolean methodBegin;

    protected MethodDeclarationMotion(boolean backwards, boolean methodBegin) {
        this.backwards = backwards;
        this.methodBegin = methodBegin;
    }

    @Override
    protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
        int dest = offset;
        while (count > 0) {
            dest = this.doIt(dest, content);
            --count;
        }
        return dest;
    }

    protected int doIt(int offset, TextContent content) {
        int depth = 0;
        int lastOpen = -1;
        int lastClose = -1;
        int testOffset = 0;
        while (testOffset < content.getTextLength()) {
            char testChar = content.getText(testOffset, 1).charAt(0);
            if (testChar == '{') {
                if (depth == 1) {
                    lastOpen = testOffset;
                }
                ++depth;
            } else if (testChar == '}') {
                if (depth == 2) {
                    lastClose = testOffset;
                }
                --depth;
            }
            if (this.backwards && ++testOffset == offset) {
                if (lastOpen == -1) {
                    lastOpen = offset;
                }
                if (lastClose == -1) {
                    lastClose = offset;
                }
                return this.methodBegin ? lastOpen : lastClose;
            }
            if (this.backwards) continue;
            if (this.methodBegin && lastOpen > offset) {
                return lastOpen;
            }
            if (this.methodBegin || lastClose <= offset) continue;
            return lastClose;
        }
        return offset;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.INCLUSIVE;
    }
}

