/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.motions.LeftRightMotion;

public class MoveToColumn
extends LeftRightMotion {
    public static final MoveToColumn INSTANCE = new MoveToColumn();
    private EditorAdaptor adaptor;

    private MoveToColumn() {
    }

    @Override
    protected void setCurrentState(EditorAdaptor editorAdaptor) {
        this.adaptor = editorAdaptor;
    }

    @Override
    protected int destination(int offset, TextContent content, int count) {
        LineInformation lineInfo = content.getLineInformationOfOffset(offset);
        int lineStart = lineInfo.getBeginOffset();
        int lineEnd = lineInfo.getEndOffset();
        String line = content.getText(lineStart, lineInfo.getLength());
        int tabstop = this.adaptor.getConfiguration().get(Options.TAB_STOP);
        int column = count - 1;
        int[] visualOffsets = StringUtils.calculateVisualOffsets(line, line.length(), tabstop);
        int charInLine = 0;
        while (charInLine < line.length() && visualOffsets[charInLine] <= column) {
            ++charInLine;
        }
        if (visualOffsets[charInLine] > column) {
            --charInLine;
        }
        return Math.min(lineEnd, lineStart + charInLine);
    }
}

