/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.LineStartMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.MoveDown;
import net.sourceforge.vrapper.vim.commands.motions.MoveUp;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class MoveUpDownNonWhitespace
extends CountAwareMotion {
    public static final MoveUpDownNonWhitespace MOVE_DOWN_LESS_ONE = new MoveUpDownNonWhitespace(true, 0);
    public static final MoveUpDownNonWhitespace MOVE_DOWN = new MoveUpDownNonWhitespace(true, 1);
    public static final MoveUpDownNonWhitespace MOVE_UP = new MoveUpDownNonWhitespace(false, 1);
    private boolean down = false;
    private int defaultAmount = 1;

    private MoveUpDownNonWhitespace(boolean down, int defaultAmount) {
        this.down = down;
        this.defaultAmount = defaultAmount;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        int linesToMove = count + this.defaultAmount;
        if (linesToMove > 0) {
            if (this.down) {
                MotionCommand.doIt(editorAdaptor, (Motion)MoveDown.INSTANCE.withCount(linesToMove - 1));
            } else {
                MotionCommand.doIt(editorAdaptor, (Motion)MoveUp.INSTANCE.withCount(linesToMove - 1));
            }
        }
        return LineStartMotion.NON_WHITESPACE.destination(editorAdaptor);
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.LINE_WISE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.RESET_EOL;
    }
}

