/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.MoveBigWORDRight;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordRight;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class MoveWordRightForUpdate
extends CountAwareMotion {
    public static final Motion MOVE_WORD_RIGHT_INSTANCE = new MoveWordRightForUpdate(new MoveWordRight(false));
    public static final Motion MOVE_BIG_WORD_RIGHT_INSTANCE = new MoveWordRightForUpdate(new MoveBigWORDRight(false));
    private CountAwareMotion delegate;

    private MoveWordRightForUpdate() {
    }

    private MoveWordRightForUpdate(CountAwareMotion delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getCount() {
        return this.delegate.getCount();
    }

    @Override
    public BorderPolicy borderPolicy() {
        return this.delegate.borderPolicy();
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return this.delegate.stickyColumnPolicy();
    }

    @Override
    public boolean isJump() {
        return this.delegate.isJump();
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        int originalOffset = editorAdaptor.getPosition().getModelOffset();
        Position delegatePosition = this.delegate.destination(editorAdaptor, count);
        int newlineLength = editorAdaptor.getConfiguration().getNewLine().length();
        int newOffset = this.offsetWithoutLastNewline(newlineLength, originalOffset, delegatePosition.getModelOffset(), editorAdaptor.getModelContent());
        return editorAdaptor.getCursorService().newPositionForModelOffset(newOffset);
    }

    public int offsetWithoutLastNewline(int newlineLength, int startingIndex, int endingIndex, TextContent content) {
        int newOffset;
        int trailingWS;
        int lastBufferIndex;
        int bufferLength = Math.min(32, endingIndex);
        if (bufferLength == 0) {
            return endingIndex;
        }
        String buffer = content.getText(endingIndex - bufferLength, bufferLength);
        int trailingNL = this.numTrailingNewLines(buffer, (lastBufferIndex = buffer.length() - 1) - (trailingWS = this.numTrailingWhitespaceChars(buffer, lastBufferIndex)));
        if (trailingNL > 0 && (newOffset = endingIndex - (trailingWS + newlineLength)) > startingIndex) {
            endingIndex = newOffset;
        }
        return endingIndex;
    }

    private int numTrailingWhitespaceChars(String buffer, int endingIndex) {
        int numWS = 0;
        while (endingIndex >= 0 && Character.isWhitespace(buffer.charAt(endingIndex)) && !VimUtils.isNewLine(buffer.substring(endingIndex, endingIndex + 1))) {
            ++numWS;
            --endingIndex;
        }
        return numWS;
    }

    private int numTrailingNewLines(String buffer, int endingIndex) {
        int numWS = 0;
        while (endingIndex >= 0 && VimUtils.isNewLine(buffer.substring(endingIndex, endingIndex + 1))) {
            ++numWS;
            --endingIndex;
        }
        return numWS;
    }
}

