/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LineWiseSelection;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class ParagraphMotion
extends CountAwareMotion {
    public static final ParagraphMotion FORWARD = new ParagraphMotion(true);
    public static final ParagraphMotion BACKWARD = new ParagraphMotion(false);
    protected final int step;

    protected ParagraphMotion(boolean moveForward) {
        this.step = moveForward ? 1 : -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 1;
        }
        modelContent = editorAdaptor.getModelContent();
        currentLine = modelContent.getLineInformationOfOffset(editorAdaptor.getPosition().getModelOffset());
        lineNo = currentLine.getNumber();
        i = 0;
        ** GOTO lbl15
        {
            lineNo += this.step;
            do {
                if (this.isInRange(modelContent, lineNo) && this.isLineEmpty(modelContent, lineNo)) continue block0;
                while (this.isInRange(modelContent, lineNo) && this.isLineNonEmpty(modelContent, lineNo)) {
                    lineNo += this.step;
                }
                ++i;
lbl15:
                // 2 sources

            } while (i < count);
        }
        lineNo = this.moveMore(modelContent, lineNo);
        offset = modelContent.getLineInformation(lineNo).getBeginOffset();
        if (this.step > 0 && lineNo + 1 == modelContent.getNumberOfLines()) {
            offset = modelContent.getLineInformation(lineNo).getEndOffset();
        }
        return editorAdaptor.getCursorService().newPositionForModelOffset(offset);
    }

    protected int moveMore(TextContent modelContent, int lineNo) {
        return lineNo;
    }

    protected boolean isLineEmpty(TextContent content, int lineNo) {
        return this.doesLineEmptinessEqual(true, content, lineNo);
    }

    protected boolean isLineNonEmpty(TextContent content, int lineNo) {
        return this.doesLineEmptinessEqual(false, content, lineNo);
    }

    protected boolean isInRange(TextContent content, int lineNo) {
        return lineNo + this.step >= 0 && lineNo + this.step < content.getNumberOfLines();
    }

    protected boolean doesLineEmptinessEqual(boolean equalWhat, TextContent content, int lineNo) {
        boolean isEmpty;
        boolean bl = isEmpty = content.getLineInformation(lineNo).getLength() == 0;
        return isEmpty == equalWhat;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.EXCLUSIVE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    public static class ParagraphTextObject
    extends AbstractTextObject {
        private final boolean outer;

        public ParagraphTextObject(boolean outer) {
            this.outer = outer;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            block19: {
                block20: {
                    if (count == 0) {
                        count = 1;
                    }
                    endsWithEOL = VimUtils.endsWithEOL(editorAdaptor);
                    content = editorAdaptor.getModelContent();
                    startLineNo = content.getLineInformationOfOffset(editorAdaptor.getPosition().getModelOffset()).getNumber();
                    if (endsWithEOL && startLineNo > 0 && startLineNo + 1 == content.getNumberOfLines()) {
                        --startLineNo;
                    }
                    cursorOnBlank = VimUtils.isLineBlank(content, startLineNo);
                    while (startLineNo > 0) {
                        upperLineIsBlank = VimUtils.isLineBlank(content, startLineNo - 1);
                        if (cursorOnBlank ^ upperLineIsBlank) break;
                        --startLineNo;
                    }
                    doNothing = false;
                    endLineNo = startLineNo;
                    if (!this.outer) break block20;
                    noMoreRepeat = false;
                    i = count;
                    while (i > 0) {
                        block21: {
                            if (!noMoreRepeat) ** GOTO lbl24
                            doNothing = true;
                            break block19;
lbl-1000:
                            // 1 sources

                            {
                                ++endLineNo;
lbl24:
                                // 2 sources

                                ** while (endLineNo + 1 < content.getNumberOfLines() && (!cursorOnBlank || VimUtils.isLineBlank((TextContent)content, (int)(endLineNo + 1))) && (cursorOnBlank || !VimUtils.isLineBlank((TextContent)content, (int)(endLineNo + 1))))
                            }
lbl25:
                            // 1 sources

                            if (endsWithEOL && endLineNo + 2 == content.getNumberOfLines()) {
                                ++endLineNo;
                            }
                            if (endLineNo + 1 < content.getNumberOfLines()) break block21;
                            if (!cursorOnBlank) ** GOTO lbl34
                            doNothing = true;
                            noMoreRepeat = true;
                            break block21;
                            while (VimUtils.isLineBlank(content, startLineNo - 1)) {
                                --startLineNo;
lbl34:
                                // 2 sources

                                if (startLineNo > 0) continue;
                            }
                            noMoreRepeat = true;
                        }
                        if (endLineNo + 1 < content.getNumberOfLines()) {
                            ++endLineNo;
                            while (!(endLineNo + 1 >= content.getNumberOfLines() || cursorOnBlank && VimUtils.isLineBlank(content, endLineNo + 1) || !cursorOnBlank && !VimUtils.isLineBlank(content, endLineNo + 1))) {
                                ++endLineNo;
                            }
                            if (endLineNo + 1 >= content.getNumberOfLines()) {
                                noMoreRepeat = true;
                            } else {
                                ++endLineNo;
                            }
                        }
                        --i;
                    }
                    break block19;
                }
                isCurrentSectionBlank = cursorOnBlank;
                noMoreRepeat = false;
                i = count;
                while (i > 0) {
                    if (noMoreRepeat) {
                        doNothing = true;
                        break;
                    }
                    while (true) {
                        if (endLineNo + 1 >= content.getNumberOfLines()) {
                            noMoreRepeat = true;
                            break;
                        }
                        if (endsWithEOL && endLineNo + 2 == content.getNumberOfLines()) {
                            ++endLineNo;
                            continue;
                        }
                        lowerLineIsBlank = VimUtils.isLineBlank(content, endLineNo + 1);
                        if (isCurrentSectionBlank ^ lowerLineIsBlank) break;
                        ++endLineNo;
                    }
                    isCurrentSectionBlank = isCurrentSectionBlank == false;
                    --i;
                }
                if (endLineNo + 1 < content.getNumberOfLines()) {
                    ++endLineNo;
                }
            }
            if (doNothing) {
                return null;
            }
            if (endLineNo + 1 < content.getNumberOfLines() && endLineNo > 0) {
                --endLineNo;
            }
            cursorService = editorAdaptor.getCursorService();
            startPos = cursorService.newPositionForModelOffset(content.getLineInformation(startLineNo).getBeginOffset());
            endPos = cursorService.newPositionForModelOffset(content.getLineInformation(endLineNo).getEndOffset());
            return new LineWiseSelection(editorAdaptor, startPos, endPos);
        }

        @Override
        public ContentType getContentType(Configuration configuration) {
            return ContentType.LINES;
        }
    }
}

