/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import java.util.Locale;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchOffset;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.modes.commandline.CommandLineHistory;
import net.sourceforge.vrapper.vim.modes.commandline.SearchCommandParser;

public class WordSearchMotion
extends SearchResultMotion {
    public static final WordSearchMotion FORWARD = new WordSearchMotion(false, true);
    public static final WordSearchMotion BACKWARD = new WordSearchMotion(true, true);
    public static final WordSearchMotion LENIENT_FORWARD = new WordSearchMotion(false, false);
    public static final WordSearchMotion LENIENT_BACKWARD = new WordSearchMotion(true, false);
    private final boolean reverse;
    private final boolean wholeWord;

    public WordSearchMotion(boolean reverse, boolean wholeWord) {
        super(false);
        this.reverse = reverse;
        this.wholeWord = wholeWord;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        String keyword = VimUtils.getWordUnderCursor(editorAdaptor, false);
        if (editorAdaptor.getConfiguration().get(Options.IGNORE_CASE).booleanValue()) {
            keyword = keyword.toLowerCase(Locale.ENGLISH);
        }
        if (this.wholeWord) {
            keyword = "\\<" + keyword + "\\>";
        }
        Search search = SearchCommandParser.createSearch(editorAdaptor, keyword, this.reverse, SearchOffset.NONE, this.wholeWord);
        editorAdaptor.getRegisterManager().setSearch(search);
        editorAdaptor.setLastSearchResult(null);
        CommandLineHistory history = CommandLineHistory.INSTANCE;
        history.setMode("search mode");
        history.append(keyword);
        return super.destination(editorAdaptor, count);
    }
}

