/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import java.util.EnumSet;
import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.RegisterState;
import net.sourceforge.vrapper.keymap.vim.SimpleKeyStroke;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.ChangeModeCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CommandWrappers;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.DummyTextObject;
import net.sourceforge.vrapper.vim.commands.InsertAdjacentCharacter;
import net.sourceforge.vrapper.vim.commands.InsertLineCommand;
import net.sourceforge.vrapper.vim.commands.InsertShiftWidth;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.MotionTextObject;
import net.sourceforge.vrapper.vim.commands.PasteAfterCommand;
import net.sourceforge.vrapper.vim.commands.PasteBeforeCommand;
import net.sourceforge.vrapper.vim.commands.PasteRegisterCommand;
import net.sourceforge.vrapper.vim.commands.RepeatInsertionCommand;
import net.sourceforge.vrapper.vim.commands.SwitchRegisterCommand;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperationTextObjectCommand;
import net.sourceforge.vrapper.vim.commands.VimCommandSequence;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.LineStartMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.MoveDown;
import net.sourceforge.vrapper.vim.commands.motions.MoveLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveLeftAcrossLines;
import net.sourceforge.vrapper.vim.commands.motions.MoveRightAcrossLines;
import net.sourceforge.vrapper.vim.commands.motions.MoveUp;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordLeft;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.AbstractMode;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.WithCountHint;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;

public class InsertMode
extends AbstractMode {
    public static final String NAME = "insert mode";
    public static final String DISPLAY_NAME = "INSERT";
    public static final String KEYMAP_NAME = "Insert Mode Keymap";
    public static final ModeSwitchHint DONT_MOVE_CURSOR = new ModeSwitchHint(){};
    public static final ModeSwitchHint DONT_LOCK_HISTORY = new ModeSwitchHint(){};
    public static final ModeSwitchHint RESUME_ON_MODE_ENTER = new ModeSwitchHint(){};
    public static final KeyStroke ESC = ConstructorWrappers.key(SpecialKey.ESC);
    public static final KeyStroke BACKSPACE = ConstructorWrappers.key(SpecialKey.BACKSPACE);
    public static final KeyStroke CTRL_R = ConstructorWrappers.ctrlKey('r');
    public static final KeyStroke CTRL_O = ConstructorWrappers.ctrlKey('o');
    public static final KeyStroke CTRL_U = ConstructorWrappers.ctrlKey('u');
    public static final KeyStroke CTRL_W = ConstructorWrappers.ctrlKey('w');
    public static final KeyStroke CTRL_X = ConstructorWrappers.ctrlKey('x');
    protected State<Command> currentState = this.buildState();
    private Position startEditPosition;
    private int numCharsDeleted;
    private boolean cleanupIndent = false;
    private boolean resumeOnEnter = false;
    private Command repetitionCommand;
    private int count;
    private ExecuteCommandHint mOnLeaveHint;

    public InsertMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void enterMode(ModeSwitchHint ... args) throws CommandExecutionException {
        ModeSwitchHint hint;
        boolean initMode = !this.resumeOnEnter;
        this.resumeOnEnter = false;
        boolean lockHistory = true;
        ModeSwitchHint[] modeSwitchHintArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            hint = modeSwitchHintArray[n2];
            if (hint == DONT_LOCK_HISTORY) {
                lockHistory = false;
            }
            ++n2;
        }
        if (initMode && lockHistory && this.editorAdaptor.getConfiguration().get(Options.ATOMIC_INSERT).booleanValue()) {
            this.editorAdaptor.getHistory().beginCompoundChange();
            this.editorAdaptor.getHistory().lock("insertmode");
        }
        this.count = 1;
        this.repetitionCommand = null;
        this.mOnLeaveHint = null;
        try {
            try {
                this.editorAdaptor.getViewportService().setRepaint(false);
                modeSwitchHintArray = args;
                n = args.length;
                n2 = 0;
                while (n2 < n) {
                    hint = modeSwitchHintArray[n2];
                    if (hint instanceof WithCountHint) {
                        WithCountHint cast = (WithCountHint)hint;
                        this.count = cast.getCount();
                    }
                    if (hint instanceof ExecuteCommandHint) {
                        if (hint instanceof ExecuteCommandHint.OnLeave) {
                            this.mOnLeaveHint = (ExecuteCommandHint)hint;
                        } else if (hint instanceof ExecuteCommandHint.OnRepeat) {
                            this.repetitionCommand = ((ExecuteCommandHint)hint).getCommand();
                        } else {
                            Command command = ((ExecuteCommandHint)hint).getCommand();
                            this.editorAdaptor.getListeners().fireCommandAboutToExecute();
                            command.execute(this.editorAdaptor);
                            this.editorAdaptor.getListeners().fireCommandExecuted();
                            if (command instanceof InsertLineCommand && this.editorAdaptor.getConfiguration().get(Options.CLEAN_INDENT).booleanValue()) {
                                this.cleanupIndent = true;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (CommandExecutionException e) {
                if (this.editorAdaptor.getConfiguration().get(Options.ATOMIC_INSERT).booleanValue()) {
                    this.editorAdaptor.getHistory().unlock("insertmode");
                    this.editorAdaptor.getHistory().endCompoundChange();
                }
                throw e;
            }
        }
        finally {
            this.editorAdaptor.getViewportService().setRepaint(true);
        }
        this.editorAdaptor.getEditorSettings().setReplaceMode(false);
        this.editorAdaptor.getCursorService().setCaret(CaretType.VERTICAL_BAR);
        if (initMode) {
            this.startEditPosition = this.editorAdaptor.getCursorService().getPosition();
            this.numCharsDeleted = 0;
        }
        super.enterMode(args);
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) {
        boolean moveCursor = true;
        ModeSwitchHint[] modeSwitchHintArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            ModeSwitchHint hint = modeSwitchHintArray[n2];
            if (hint == DONT_MOVE_CURSOR) {
                moveCursor = false;
            }
            if (hint == RESUME_ON_MODE_ENTER) {
                this.resumeOnEnter = true;
                return;
            }
            ++n2;
        }
        try {
            this.saveTypedText();
            try {
                if (moveCursor) {
                    MotionCommand.doIt(this.editorAdaptor, MoveLeft.INSTANCE);
                }
            }
            catch (CommandExecutionException e) {
                this.editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
            this.repeatInsert();
        }
        finally {
            if (this.editorAdaptor.getConfiguration().get(Options.ATOMIC_INSERT).booleanValue()) {
                this.editorAdaptor.getHistory().unlock("insertmode");
                this.editorAdaptor.getHistory().endCompoundChange();
            }
        }
        Position lastInsertOffset = this.editorAdaptor.getPosition();
        if (lastInsertOffset.getModelOffset() < this.editorAdaptor.getModelContent().getTextLength()) {
            lastInsertOffset = lastInsertOffset.addModelOffset(1);
        }
        this.editorAdaptor.getCursorService().setMark("^", lastInsertOffset);
    }

    private void repeatInsert() {
        if (this.count > 1) {
            try {
                CommandWrappers.repeat(this.count - 1, this.editorAdaptor.getRegisterManager().getLastInsertion()).execute(this.editorAdaptor);
            }
            catch (CommandExecutionException e) {
                this.editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
        }
    }

    private void saveTypedText() {
        Register lastEditRegister = this.editorAdaptor.getRegisterManager().getLastEditRegister();
        TextContent content = this.editorAdaptor.getModelContent();
        Position position = this.editorAdaptor.getCursorService().getPosition();
        if (this.startEditPosition.getModelOffset() > this.editorAdaptor.getModelContent().getTextLength()) {
            this.startEditPosition = this.editorAdaptor.getCursorService().newPositionForModelOffset(this.editorAdaptor.getModelContent().getTextLength());
        } else if (this.cleanupIndent && position.getModelOffset() == this.startEditPosition.getModelOffset()) {
            int startOfLine = content.getLineInformationOfOffset(position.getModelOffset()).getBeginOffset();
            String indent = content.getText(startOfLine, position.getModelOffset() - startOfLine);
            if (indent.length() > 0 && VimUtils.isBlank(indent)) {
                content.replace(startOfLine, indent.length(), "");
            }
            this.startEditPosition = position = this.editorAdaptor.getPosition();
        }
        this.cleanupIndent = false;
        CursorService cur = this.editorAdaptor.getCursorService();
        cur.setMark("[", this.startEditPosition);
        cur.setMark("]", position);
        Position editRangeStart = this.startEditPosition.addModelOffset(-this.numCharsDeleted);
        if (editRangeStart.getModelOffset() < 0) {
            VrapperLog.error("NumCharsDeleted caused us to move out of bounds! Startposition: " + this.startEditPosition + ", numCharsDeleted: " + this.numCharsDeleted);
            editRangeStart = editRangeStart.setModelOffset(0);
        }
        String text = content.getText(new StartEndTextRange(editRangeStart, position));
        StringRegisterContent registerContent = new StringRegisterContent(ContentType.TEXT, text);
        lastEditRegister.setContent(registerContent);
        Command repetition = InsertMode.createRepetition(lastEditRegister, this.repetitionCommand, this.count, this.numCharsDeleted, 0);
        this.editorAdaptor.getRegisterManager().setLastInsertion(this.count > 1 ? (Command)repetition.withCount(this.count) : repetition);
    }

    public static Command createRepetition(Register lastEditRegister, Command repetitionCommand, int count, int deleteCharsToLeft, int deleteCharsToRight) {
        TextObject toDelete;
        Command repetition = null;
        if (repetitionCommand != null) {
            repetition = (Command)repetitionCommand.repetition();
        }
        CountAwareCommand paste = count > 1 ? PasteAfterCommand.CURSOR_ON_TEXT : PasteBeforeCommand.CURSOR_ON_TEXT;
        Command deleteCharsCmd = null;
        if (deleteCharsToLeft > 0) {
            toDelete = new MotionTextObject(MoveLeft.INSTANCE).withCount(deleteCharsToLeft);
            deleteCharsCmd = new TextOperationTextObjectCommand(DeleteOperation.INSTANCE, toDelete);
        }
        if (deleteCharsToRight > 0) {
            toDelete = new MotionTextObject(MoveLeft.INSTANCE).withCount(deleteCharsToRight);
            deleteCharsCmd = CommandWrappers.seq(deleteCharsCmd, new TextOperationTextObjectCommand(DeleteOperation.INSTANCE, toDelete));
        }
        return CommandWrappers.dontRepeat(CommandWrappers.seq(repetition, deleteCharsCmd, new SwitchRegisterCommand(lastEditRegister), paste, new SwitchRegisterCommand('\u0000')));
    }

    @Override
    public boolean handleKey(KeyStroke stroke) {
        Transition<Command> transition;
        if (this.startEditPosition.getModelOffset() - this.editorAdaptor.getCursorService().getPosition().getModelOffset() > this.numCharsDeleted) {
            this.numCharsDeleted = this.startEditPosition.getModelOffset() - this.editorAdaptor.getCursorService().getPosition().getModelOffset();
        }
        if ((transition = this.currentState.press(stroke)) != null && transition.getValue() != null) {
            try {
                if (!this.editorAdaptor.getConfiguration().get(Options.ATOMIC_INSERT).booleanValue()) {
                    this.editorAdaptor.getListeners().fireCommandAboutToExecute();
                }
                transition.getValue().execute(this.editorAdaptor);
                if (!this.editorAdaptor.getConfiguration().get(Options.ATOMIC_INSERT).booleanValue()) {
                    this.editorAdaptor.getListeners().fireCommandExecuted();
                }
            }
            catch (CommandExecutionException e) {
                this.editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
            this.editorAdaptor.getListeners().fireStateReset(true);
            return true;
        }
        if (stroke.equals(ESC)) {
            this.editorAdaptor.changeModeSafely("normal mode", new ModeSwitchHint[0]);
            if (this.editorAdaptor.getConfiguration().get(Options.IM_DISABLE).booleanValue()) {
                this.editorAdaptor.getEditorSettings().disableInputMethod();
            }
            if (this.mOnLeaveHint != null && stroke.equals(ESC)) {
                try {
                    this.editorAdaptor.getListeners().fireCommandAboutToExecute();
                    this.mOnLeaveHint.getCommand().execute(this.editorAdaptor);
                    this.editorAdaptor.getListeners().fireCommandExecuted();
                }
                catch (CommandExecutionException e) {
                    this.editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
            }
            return true;
        }
        if (stroke.equals(CTRL_R)) {
            this.editorAdaptor.changeModeSafely("paste register", RESUME_ON_MODE_ENTER, this.mOnLeaveHint);
            return true;
        }
        if (stroke.equals(CTRL_O)) {
            this.editorAdaptor.changeModeSafely("temporary normal mode", new ModeSwitchHint[0]);
            return true;
        }
        if (stroke.equals(CTRL_U) || stroke.equals(CTRL_W)) {
            try {
                CursorService cur = this.editorAdaptor.getCursorService();
                int cursorPos = cur.getPosition().getModelOffset();
                TextContent txt = this.editorAdaptor.getModelContent();
                int startEditPos = this.startEditPosition.getModelOffset();
                LineInformation line = txt.getLineInformationOfOffset(cursorPos);
                CountAwareMotion motion = stroke.equals(CTRL_U) ? LineStartMotion.NON_WHITESPACE : MoveWordLeft.INSTANCE;
                Position pos = motion.destination(this.editorAdaptor);
                if (pos.getModelOffset() < line.getBeginOffset() || pos.getModelOffset() == cursorPos) {
                    motion = LineStartMotion.COLUMN0;
                    pos = motion.destination(this.editorAdaptor);
                }
                int position = pos.getModelOffset();
                if (cursorPos == line.getBeginOffset()) {
                    position = txt.getLineInformation(line.getNumber() - 1).getEndOffset();
                } else if (cursorPos > startEditPos && position < startEditPos) {
                    position = startEditPos;
                }
                int length = cursorPos - position;
                txt.replace(position, length, "");
                if (position < startEditPos) {
                    this.startEditPosition = this.startEditPosition.setModelOffset(position);
                    this.numCharsDeleted = 0;
                }
            }
            catch (CommandExecutionException commandExecutionException) {}
            return true;
        }
        if (Boolean.FALSE.equals(this.editorAdaptor.getConfiguration().get(Options.MODIFIABLE)) && (stroke.getSpecialKey() == null || !VimConstants.SPECIAL_KEYS_ALLOWED_FOR_UNMODIFIABLE_INSERT.contains((Object)stroke.getSpecialKey()))) {
            this.editorAdaptor.getUserInterfaceService().setErrorMessage("Cannot modify contents, 'modifiable' is off!");
            return true;
        }
        if (!this.allowed(stroke)) {
            this.resetEditingSession();
        } else {
            if (stroke.isVirtual()) {
                this.handleVirtualStroke(stroke);
                return true;
            }
            if (stroke.equals(BACKSPACE) && this.editorAdaptor.getConfiguration().get(Options.SOFT_TAB) > 1) {
                return this.softTabDelete();
            }
        }
        return false;
    }

    public void resetEditingSession() {
        this.startEditPosition = this.editorAdaptor.getCursorService().getPosition();
        this.numCharsDeleted = 0;
        this.count = 1;
        this.repetitionCommand = null;
        this.editorAdaptor.getRegisterManager().setLastEdit(new RepeatInsertionCommand(null));
        if (this.editorAdaptor.getConfiguration().get(Options.ATOMIC_INSERT).booleanValue()) {
            this.editorAdaptor.getHistory().unlock("insertmode");
            this.editorAdaptor.getHistory().endCompoundChange();
            this.editorAdaptor.getHistory().beginCompoundChange();
            this.editorAdaptor.getHistory().lock("insertmode");
        }
    }

    private boolean softTabDelete() {
        TextContent model = this.editorAdaptor.getModelContent();
        int softTabStop = this.editorAdaptor.getConfiguration().get(Options.SOFT_TAB);
        int pos = this.editorAdaptor.getPosition().getModelOffset();
        int start = model.getLineInformationOfOffset(pos).getBeginOffset();
        String text = model.getText(start, pos - start);
        int spaceCount = 0;
        int i = text.length() - 1;
        while (i >= 0) {
            if (text.charAt(i) != ' ') break;
            ++spaceCount;
            --i;
        }
        if (spaceCount < softTabStop) {
            return false;
        }
        int toDelete = 0;
        toDelete = spaceCount % softTabStop == 0 ? softTabStop : spaceCount % softTabStop;
        model.replace(pos - toDelete, toDelete, "");
        this.editorAdaptor.setPosition(this.editorAdaptor.getCursorService().newPositionForModelOffset(pos - toDelete), StickyColumnPolicy.NEVER);
        return true;
    }

    private void handleVirtualStroke(KeyStroke stroke) {
        TextContent c = this.editorAdaptor.getModelContent();
        if (SpecialKey.BACKSPACE.equals((Object)stroke.getSpecialKey())) {
            int pos = this.editorAdaptor.getPosition().getModelOffset();
            LineInformation line = c.getLineInformationOfOffset(pos);
            if (pos > 0) {
                int pos2 = pos > line.getBeginOffset() ? pos - 1 : c.getLineInformation(line.getNumber() - 1).getEndOffset();
                c.replace(pos2, pos - pos2, "");
                this.editorAdaptor.setPosition(this.editorAdaptor.getCursorService().newPositionForModelOffset(pos2), StickyColumnPolicy.NEVER);
            }
        } else if (SpecialKey.ARROW_LEFT.equals((Object)stroke.getSpecialKey()) || SpecialKey.ARROW_RIGHT.equals((Object)stroke.getSpecialKey()) || SpecialKey.ARROW_UP.equals((Object)stroke.getSpecialKey()) || SpecialKey.ARROW_DOWN.equals((Object)stroke.getSpecialKey())) {
            Motion direction;
            switch (stroke.getSpecialKey()) {
                case ARROW_LEFT: {
                    direction = MoveLeftAcrossLines.INSTANCE;
                    break;
                }
                case ARROW_RIGHT: {
                    direction = MoveRightAcrossLines.INSTANCE_BEHIND_CHAR;
                    break;
                }
                case ARROW_UP: {
                    direction = MoveUp.INSTANCE;
                    break;
                }
                case ARROW_DOWN: {
                    direction = MoveDown.INSTANCE;
                    break;
                }
                default: {
                    throw new RuntimeException("No matching direction!");
                }
            }
            try {
                Position destination = direction.destination(this.editorAdaptor);
                this.editorAdaptor.setPosition(destination, direction.stickyColumnPolicy());
            }
            catch (CommandExecutionException e) {
                VrapperLog.error("Failed to navigate in editor", e);
            }
        } else {
            String s = SpecialKey.RETURN.equals((Object)stroke.getSpecialKey()) ? this.editorAdaptor.getConfiguration().getNewLine() : (SpecialKey.TAB.equals((Object)stroke.getSpecialKey()) ? "\t" : String.valueOf(stroke.getCharacter()));
            this.handleVirtualInsert(c, s);
        }
    }

    protected void handleVirtualInsert(TextContent content, String str) {
        content.smartInsert(str);
    }

    private boolean allowed(KeyStroke stroke) {
        SpecialKey specialKey = stroke.getSpecialKey();
        if (specialKey != null) {
            return VimConstants.SPECIAL_KEYS_ALLOWED_FOR_INSERT.contains((Object)specialKey);
        }
        return true;
    }

    protected State<Command> buildState() {
        State<Command> platformSpecificState = this.editorAdaptor.getPlatformSpecificStateProvider().getState(NAME);
        if (platformSpecificState == null) {
            platformSpecificState = EmptyState.getInstance();
        }
        return RegisterState.wrap(StateUtils.union(platformSpecificState, ConstructorWrappers.state(ConstructorWrappers.leafBind(new SimpleKeyStroke('o', EnumSet.of(KeyStroke.Modifier.ALT)), new ChangeModeCommand("command mode", RESUME_ON_MODE_ENTER)), ConstructorWrappers.leafCtrlBind('a', PasteRegisterCommand.PASTE_LAST_INSERT), ConstructorWrappers.leafCtrlBind('e', InsertAdjacentCharacter.LINE_BELOW), ConstructorWrappers.leafCtrlBind('y', InsertAdjacentCharacter.LINE_ABOVE), ConstructorWrappers.leafCtrlBind('t', new TextOperationTextObjectCommand(InsertShiftWidth.INSERT, new DummyTextObject(null))), ConstructorWrappers.leafCtrlBind('d', new TextOperationTextObjectCommand(InsertShiftWidth.REMOVE, new DummyTextObject(null))))));
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return KEYMAP_NAME;
    }

    public static class MoveRightOverLineBreak
    extends CountIgnoringNonRepeatableCommand {
        private final int offset;

        public MoveRightOverLineBreak(int offset) {
            this.offset = offset;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            editorAdaptor.setPosition(editorAdaptor.getPosition().addModelOffset(this.offset), StickyColumnPolicy.ON_CHANGE);
        }
    }

    public static class SimpleInsertCommandSequence
    extends VimCommandSequence {
        public SimpleInsertCommandSequence(Command ... commands) {
            super(commands);
        }

        @Override
        public Command withCount(final int count) {
            return new CountIgnoringNonRepeatableCommand(){

                @Override
                public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
                    SimpleInsertCommandSequence.this.execute(editorAdaptor);
                    int i = 1;
                    while (i < count) {
                        Position pos = editorAdaptor.getPosition();
                        editorAdaptor.setPosition(pos.addModelOffset(1), StickyColumnPolicy.NEVER);
                        SimpleInsertCommandSequence.this.execute(editorAdaptor);
                        ++i;
                    }
                }
            };
        }
    }
}

