/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.KeyMapInfo;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;

public final class KeyMapResolver {
    public static final String OMAP_NAME = String.valueOf(KeyMapResolver.class.getCanonicalName()) + ".OMAP";
    private final State<KeyMapInfo> initialState;
    private final KeyMapInfo initialKeyMap;
    private State<KeyMapInfo> currentState;
    private KeyMapInfo activeKeyMap;

    KeyMapResolver(State<KeyMapInfo> initialState, String startKeyMap) {
        this.initialState = initialState;
        this.currentState = initialState;
        this.activeKeyMap = this.initialKeyMap = new KeyMapInfo(startKeyMap, "init");
    }

    public void storeKey(KeyStroke key) {
        if (this.currentState == null) {
            this.activeKeyMap = null;
        } else {
            Transition<KeyMapInfo> trans = this.currentState.press(key);
            if (trans == null) {
                this.currentState = null;
                this.activeKeyMap = null;
            } else {
                this.currentState = trans.getNextState();
                this.activeKeyMap = trans.getValue();
            }
        }
    }

    public String getKeyMapName(KeyStroke stroke) {
        KeyMapInfo nextKeyMap;
        if (this.activeKeyMap == null || this.currentState == null) {
            return null;
        }
        Transition<KeyMapInfo> nextTrans = this.currentState.press(stroke);
        KeyMapInfo keyMapInfo = nextKeyMap = nextTrans != null ? nextTrans.getValue() : null;
        if (nextKeyMap == null) {
            return this.activeKeyMap.getKeyMapName();
        }
        if (nextKeyMap != null && !nextKeyMap.getKeyGroupId().equals(this.activeKeyMap.getKeyGroupId())) {
            return this.activeKeyMap.getKeyMapName();
        }
        return null;
    }

    public void reset() {
        this.currentState = this.initialState;
        this.activeKeyMap = this.initialKeyMap;
    }
}

