/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.ChangeToSearchModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.LineWiseSelection;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SwapLinewiseSelectionSidesCommand;
import net.sourceforge.vrapper.vim.commands.VisualMotionCommand;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;

public class LinewiseVisualMode
extends AbstractVisualMode {
    public static final String NAME = "linewise visual mode";
    public static final String DISPLAY_NAME = "VISUAL LINE";

    public LinewiseVisualMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public void fixCaret() {
        CaretType caret = CaretType.RECTANGULAR;
        if (this.editorAdaptor.getConfiguration().get(Options.SELECTION).equals("exclusive")) {
            caret = CaretType.VERTICAL_BAR;
        }
        this.editorAdaptor.getCursorService().setCaret(caret);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    protected State<Command> buildInitialState() {
        VisualMotionCommand doSearchCommand = new VisualMotionCommand(SearchResultMotion.REPEAT);
        State linewiseSpecific = ConstructorWrappers.state(ConstructorWrappers.leafBind('o', SwapLinewiseSelectionSidesCommand.INSTANCE), ConstructorWrappers.leafBind('v', new ChangeToVisualModeCommand("visual mode")), ConstructorWrappers.leafBind('V', LeaveVisualModeCommand.INSTANCE), ConstructorWrappers.leafCtrlBind('v', new ChangeToVisualModeCommand("block visual mode")), ConstructorWrappers.leafCtrlBind('q', new ChangeToVisualModeCommand("block visual mode")), ConstructorWrappers.leafBind('/', new ChangeToSearchModeCommand(false, doSearchCommand, true)), ConstructorWrappers.leafBind('?', new ChangeToSearchModeCommand(true, doSearchCommand, true)));
        return StateUtils.union(this.getPlatformSpecificState(NAME), linewiseSpecific, super.buildInitialState());
    }

    @Override
    protected Selection fixSelection(Selection selection) {
        if (!selection.getContentType(this.editorAdaptor.getConfiguration()).equals((Object)ContentType.LINES)) {
            Position start = selection.getFrom();
            Position end = selection.getTo();
            return new LineWiseSelection(this.editorAdaptor, start, end);
        }
        return selection;
    }
}

