/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import java.util.HashMap;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.platform.SimpleConfiguration;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.ChangeToInsertModeCommand;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.WithCountHint;

public class ReplaceMode
extends InsertMode {
    public static final String NAME = "replace mode";
    public static final String DISPLAY_NAME = "REPLACE";
    private int startCursorOffset;
    private boolean afterNewline = false;
    private HashMap<Integer, String> replacedChars = new HashMap();

    public ReplaceMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void enterMode(ModeSwitchHint ... args) throws CommandExecutionException {
        this.editorAdaptor.getCursorService().setCaret(CaretType.UNDERLINE);
        this.startCursorOffset = this.editorAdaptor.getCursorService().getPosition().getModelOffset();
        this.afterNewline = false;
        super.enterMode(args);
        this.editorAdaptor.getEditorSettings().setReplaceMode(true);
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) {
        this.editorAdaptor.getEditorSettings().setReplaceMode(false);
        this.replacedChars.clear();
        super.leaveMode(new ModeSwitchHint[0]);
    }

    @Override
    public boolean handleKey(KeyStroke stroke) {
        int cursorOffset = this.editorAdaptor.getCursorService().getPosition().getModelOffset();
        if (stroke.equals(BACKSPACE)) {
            if (this.replacedChars.containsKey(--cursorOffset)) {
                String toRestore = this.replacedChars.get(cursorOffset);
                if (this.afterNewline && VimUtils.isNewLine(toRestore)) {
                    this.editorAdaptor.getModelContent().replace(cursorOffset, 1, "");
                    this.afterNewline = false;
                } else {
                    this.editorAdaptor.getModelContent().replace(cursorOffset, 1, toRestore);
                }
                Position newPos = this.editorAdaptor.getCursorService().newPositionForModelOffset(cursorOffset);
                this.editorAdaptor.getCursorService().setPosition(newPos, StickyColumnPolicy.ON_CHANGE);
                return true;
            }
            if (cursorOffset < this.startCursorOffset) {
                Position newPos = this.editorAdaptor.getCursorService().newPositionForModelOffset(cursorOffset);
                this.editorAdaptor.getCursorService().setPosition(newPos, StickyColumnPolicy.ON_CHANGE);
                return true;
            }
            return super.handleKey(stroke);
        }
        if (cursorOffset < this.editorAdaptor.getModelContent().getTextLength()) {
            String toReplace = this.editorAdaptor.getModelContent().getText(cursorOffset, 1);
            if (!this.afterNewline) {
                this.replacedChars.put(cursorOffset, toReplace);
            }
            if (VimUtils.isNewLine(toReplace)) {
                this.afterNewline = true;
            }
        } else {
            this.afterNewline = true;
        }
        return super.handleKey(stroke);
    }

    @Override
    protected void handleVirtualInsert(TextContent content, String str) {
        content.replace(this.editorAdaptor.getPosition().getModelOffset(), str.length(), str);
        this.editorAdaptor.setPosition(this.editorAdaptor.getPosition().addModelOffset(str.length()), StickyColumnPolicy.NEVER);
    }

    public static class ChangeToReplaceModeCommand
    extends ChangeToInsertModeCommand {
        @Override
        public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            editorAdaptor.changeMode(ReplaceMode.NAME, new WithCountHint(count));
        }

        @Override
        public CountAwareCommand repetition() {
            return new RepeatReplaceCommand();
        }
    }

    private static class RepeatReplaceCommand
    extends CountAwareCommand {
        private RepeatReplaceCommand() {
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            editorAdaptor.getHistory().beginCompoundChange();
            TextContent modelContent = editorAdaptor.getModelContent();
            String editorNewline = editorAdaptor.getConfiguration().getNewLine();
            String text = editorAdaptor.getRegisterManager().getLastEditRegister().getContent().getText();
            int pos = editorAdaptor.getPosition().getModelOffset();
            if (count == 0) {
                count = 1;
            }
            int j = 0;
            while (j < count) {
                int start = 0;
                int i = 0;
                while (i < text.length()) {
                    char c = text.charAt(i);
                    if (VimUtils.isNewLine(String.valueOf(c))) {
                        String replace = text.substring(start, i);
                        String nl = text.substring(i);
                        SimpleConfiguration.NewLine newline = SimpleConfiguration.NewLine.parse(nl);
                        this.replace(modelContent, pos, replace);
                        modelContent.replace(pos + replace.length(), 0, editorNewline);
                        i += newline.nl.length() - 1;
                        pos += replace.length() + editorNewline.length();
                        start += replace.length() + newline.nl.length();
                    }
                    ++i;
                }
                String replace = text.substring(start);
                this.replace(modelContent, pos, replace);
                pos += text.length();
                ++j;
            }
            editorAdaptor.getHistory().endCompoundChange();
        }

        private void replace(TextContent modelContent, int pos, String replace) {
            int length = replace.length();
            String toReplace = modelContent.getText(pos, length);
            int i = 0;
            while (i < length) {
                String c = String.valueOf(toReplace.charAt(i));
                if (VimUtils.isNewLine(c)) {
                    length = i;
                }
                ++i;
            }
            modelContent.replace(pos, length, replace);
        }

        @Override
        public CountAwareCommand repetition() {
            return null;
        }
    }
}

